/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms.bc;

import java.io.InputStream;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.RecipientOperator;
import resources.dependencies.org.bouncycastle.cms.bc.BcKEKRecipient;
import resources.dependencies.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import resources.dependencies.org.bouncycastle.crypto.BufferedBlockCipher;
import resources.dependencies.org.bouncycastle.crypto.StreamCipher;
import resources.dependencies.org.bouncycastle.crypto.io.CipherInputStream;
import resources.dependencies.org.bouncycastle.crypto.params.KeyParameter;
import resources.dependencies.org.bouncycastle.operator.InputDecryptor;
import resources.dependencies.org.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper bcSymmetricKeyUnwrapper) {
        super(bcSymmetricKeyUnwrapper);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        KeyParameter keyParameter = (KeyParameter)this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Object object = EnvelopedDataHelper.createContentCipher(false, keyParameter, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                if (object instanceof BufferedBlockCipher) {
                    return new CipherInputStream(inputStream, (BufferedBlockCipher)object);
                }
                return new CipherInputStream(inputStream, (StreamCipher)object);
            }
        });
    }
}

