/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.jce.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import resources.dependencies.org.bouncycastle.asn1.ASN1EncodableVector;
import resources.dependencies.org.bouncycastle.asn1.ASN1GeneralizedTime;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import resources.dependencies.org.bouncycastle.asn1.ASN1OctetString;
import resources.dependencies.org.bouncycastle.asn1.ASN1Sequence;
import resources.dependencies.org.bouncycastle.asn1.DERSequence;
import resources.dependencies.org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import resources.dependencies.org.bouncycastle.asn1.ocsp.CertID;
import resources.dependencies.org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import resources.dependencies.org.bouncycastle.asn1.ocsp.OCSPRequest;
import resources.dependencies.org.bouncycastle.asn1.ocsp.OCSPResponse;
import resources.dependencies.org.bouncycastle.asn1.ocsp.Request;
import resources.dependencies.org.bouncycastle.asn1.ocsp.ResponseBytes;
import resources.dependencies.org.bouncycastle.asn1.ocsp.ResponseData;
import resources.dependencies.org.bouncycastle.asn1.ocsp.Signature;
import resources.dependencies.org.bouncycastle.asn1.ocsp.SingleResponse;
import resources.dependencies.org.bouncycastle.asn1.ocsp.TBSRequest;
import resources.dependencies.org.bouncycastle.asn1.x509.Extension;
import resources.dependencies.org.bouncycastle.asn1.x509.Extensions;
import resources.dependencies.org.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import resources.dependencies.org.bouncycastle.jcajce.util.JcaJceHelper;
import resources.dependencies.org.bouncycastle.jce.provider.ProvOcspRevocationChecker;
import resources.dependencies.org.bouncycastle.util.io.Streams;

class OcspCache {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static final int DEFAULT_MAX_RESPONSE_SIZE = 32768;
    private static Map<URI, WeakReference<Map<CertID, OCSPResponse>>> cache = Collections.synchronizedMap(new WeakHashMap());

    OcspCache() {
    }

    static OCSPResponse getOcspResponse(CertID certID, PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters, URI uRI, X509Certificate x509Certificate, List<java.security.cert.Extension> list, JcaJceHelper jcaJceHelper) throws CertPathValidatorException {
        byte[] byArray;
        java.security.cert.Extension extension;
        Object object;
        Object object2;
        HashMap<CertID, OCSPResponse> hashMap = null;
        WeakReference<Map<CertID, OCSPResponse>> weakReference = cache.get(uRI);
        if (weakReference != null) {
            hashMap = (HashMap<CertID, OCSPResponse>)weakReference.get();
        }
        if (hashMap != null && (object2 = (OCSPResponse)hashMap.get(certID)) != null) {
            object = BasicOCSPResponse.getInstance(ASN1OctetString.getInstance(((OCSPResponse)object2).getResponseBytes().getResponse()).getOctets());
            boolean bl = OcspCache.isCertIDFoundAndCurrent((BasicOCSPResponse)object, pKIXCertRevocationCheckerParameters.getValidDate(), certID);
            if (bl) {
                return object2;
            }
            hashMap.remove(certID);
        }
        try {
            object2 = uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new CertPathValidatorException("configuration error: " + malformedURLException.getMessage(), (Throwable)malformedURLException, pKIXCertRevocationCheckerParameters.getCertPath(), pKIXCertRevocationCheckerParameters.getIndex());
        }
        object = new ASN1EncodableVector();
        ((ASN1EncodableVector)object).add(new Request(certID, null));
        List<java.security.cert.Extension> list2 = list;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        byte[] byArray2 = null;
        for (int i = 0; i != list2.size(); ++i) {
            extension = list2.get(i);
            byArray = extension.getValue();
            if (OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId().equals(extension.getId())) {
                byArray2 = byArray;
            }
            aSN1EncodableVector.add(new Extension(new ASN1ObjectIdentifier(extension.getId()), extension.isCritical(), byArray));
        }
        TBSRequest tBSRequest = aSN1EncodableVector.size() != 0 ? new TBSRequest(null, (ASN1Sequence)new DERSequence((ASN1EncodableVector)object), Extensions.getInstance(new DERSequence(aSN1EncodableVector))) : new TBSRequest(null, (ASN1Sequence)new DERSequence((ASN1EncodableVector)object), (Extensions)null);
        extension = null;
        try {
            OCSPResponse oCSPResponse;
            byArray = new OCSPRequest(tBSRequest, (Signature)((Object)extension)).getEncoded();
            HttpURLConnection httpURLConnection = (HttpURLConnection)((URL)object2).openConnection();
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(15000);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Content-length", String.valueOf(byArray.length));
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            InputStream inputStream = httpURLConnection.getInputStream();
            int n = httpURLConnection.getContentLength();
            if (n < 0) {
                n = 32768;
            }
            if (0 == (oCSPResponse = OCSPResponse.getInstance(Streams.readAllLimited(inputStream, n))).getResponseStatus().getIntValue()) {
                boolean bl = false;
                ResponseBytes responseBytes = ResponseBytes.getInstance(oCSPResponse.getResponseBytes());
                if (responseBytes.getResponseType().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic)) {
                    BasicOCSPResponse basicOCSPResponse = BasicOCSPResponse.getInstance(responseBytes.getResponse().getOctets());
                    boolean bl2 = bl = ProvOcspRevocationChecker.validatedOcspResponse(basicOCSPResponse, pKIXCertRevocationCheckerParameters, byArray2, x509Certificate, jcaJceHelper) && OcspCache.isCertIDFoundAndCurrent(basicOCSPResponse, pKIXCertRevocationCheckerParameters.getValidDate(), certID);
                }
                if (!bl) {
                    throw new CertPathValidatorException("OCSP response failed to validate", null, pKIXCertRevocationCheckerParameters.getCertPath(), pKIXCertRevocationCheckerParameters.getIndex());
                }
                weakReference = cache.get(uRI);
                if (weakReference != null) {
                    hashMap = (Map)weakReference.get();
                }
                if (hashMap != null) {
                    hashMap.put(certID, oCSPResponse);
                } else {
                    hashMap = new HashMap<CertID, OCSPResponse>();
                    hashMap.put(certID, oCSPResponse);
                    cache.put(uRI, new WeakReference(hashMap));
                }
                return oCSPResponse;
            }
            throw new CertPathValidatorException("OCSP responder failed: " + oCSPResponse.getResponseStatus().getValue(), null, pKIXCertRevocationCheckerParameters.getCertPath(), pKIXCertRevocationCheckerParameters.getIndex());
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("configuration error: " + iOException.getMessage(), (Throwable)iOException, pKIXCertRevocationCheckerParameters.getCertPath(), pKIXCertRevocationCheckerParameters.getIndex());
        }
    }

    private static boolean isCertIDFoundAndCurrent(BasicOCSPResponse basicOCSPResponse, Date date, CertID certID) {
        ResponseData responseData = ResponseData.getInstance(basicOCSPResponse.getTbsResponseData());
        ASN1Sequence aSN1Sequence = responseData.getResponses();
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            SingleResponse singleResponse = SingleResponse.getInstance(aSN1Sequence.getObjectAt(i));
            if (!certID.equals(singleResponse.getCertID())) continue;
            ASN1GeneralizedTime aSN1GeneralizedTime = singleResponse.getNextUpdate();
            try {
                if (aSN1GeneralizedTime != null && date.after(aSN1GeneralizedTime.getDate())) {
                    return false;
                }
            }
            catch (ParseException parseException) {
                return false;
            }
            return true;
        }
        return false;
    }
}

