/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.operator.bc;

import java.io.IOException;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import resources.dependencies.org.bouncycastle.crypto.ExtendedDigest;
import resources.dependencies.org.bouncycastle.crypto.Signer;
import resources.dependencies.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import resources.dependencies.org.bouncycastle.crypto.signers.DSADigestSigner;
import resources.dependencies.org.bouncycastle.crypto.signers.ECDSASigner;
import resources.dependencies.org.bouncycastle.crypto.util.PublicKeyFactory;
import resources.dependencies.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import resources.dependencies.org.bouncycastle.operator.OperatorCreationException;
import resources.dependencies.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcECContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new ECDSASigner(), extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

