/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.pqc.crypto.mldsa;

import java.security.SecureRandom;
import resources.dependencies.org.bouncycastle.crypto.CipherParameters;
import resources.dependencies.org.bouncycastle.crypto.CryptoException;
import resources.dependencies.org.bouncycastle.crypto.DataLengthException;
import resources.dependencies.org.bouncycastle.crypto.Signer;
import resources.dependencies.org.bouncycastle.crypto.digests.SHAKEDigest;
import resources.dependencies.org.bouncycastle.crypto.params.ParametersWithContext;
import resources.dependencies.org.bouncycastle.crypto.params.ParametersWithRandom;
import resources.dependencies.org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import resources.dependencies.org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import resources.dependencies.org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import resources.dependencies.org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;

public class MLDSASigner
implements Signer {
    private static final byte[] EMPTY_CONTEXT = new byte[0];
    private MLDSAPublicKeyParameters pubKey;
    private MLDSAPrivateKeyParameters privKey;
    private SecureRandom random;
    private MLDSAEngine engine;
    private SHAKEDigest msgDigest;

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        Object object;
        byte[] byArray = EMPTY_CONTEXT;
        if (cipherParameters instanceof ParametersWithContext) {
            object = (ParametersWithContext)cipherParameters;
            byArray = ((ParametersWithContext)object).getContext();
            cipherParameters = ((ParametersWithContext)object).getParameters();
            if (byArray.length > 255) {
                throw new IllegalArgumentException("context too long");
            }
        }
        if (bl) {
            this.pubKey = null;
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.privKey = (MLDSAPrivateKeyParameters)parametersWithRandom.getParameters();
                this.random = parametersWithRandom.getRandom();
            } else {
                this.privKey = (MLDSAPrivateKeyParameters)cipherParameters;
                this.random = null;
            }
            object = this.privKey.getParameters();
            this.engine = ((MLDSAParameters)object).getEngine(this.random);
            this.engine.initSign(this.privKey.tr, false, byArray);
        } else {
            this.pubKey = (MLDSAPublicKeyParameters)cipherParameters;
            this.privKey = null;
            this.random = null;
            object = this.pubKey.getParameters();
            this.engine = ((MLDSAParameters)object).getEngine(null);
            this.engine.initVerify(this.pubKey.rho, this.pubKey.t1, false, byArray);
        }
        if (((MLDSAParameters)object).isPreHash()) {
            throw new IllegalArgumentException("\"pure\" ml-dsa must use non pre-hash parameters");
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.msgDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.msgDigest.update(byArray, n, n2);
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        byte[] byArray = new byte[32];
        if (this.random != null) {
            this.random.nextBytes(byArray);
        }
        byte[] byArray2 = this.engine.generateSignature(this.msgDigest, this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, byArray);
        this.reset();
        return byArray2;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        boolean bl = this.engine.verifyInternal(byArray, byArray.length, this.msgDigest, this.pubKey.rho, this.pubKey.t1);
        this.reset();
        return bl;
    }

    @Override
    public void reset() {
        this.msgDigest = this.engine.getShake256Digest();
    }

    protected byte[] internalGenerateSignature(byte[] byArray, byte[] byArray2) {
        MLDSAEngine mLDSAEngine = this.privKey.getParameters().getEngine(this.random);
        mLDSAEngine.initSign(this.privKey.tr, false, null);
        return mLDSAEngine.signInternal(byArray, byArray.length, this.privKey.rho, this.privKey.k, this.privKey.t0, this.privKey.s1, this.privKey.s2, byArray2);
    }

    protected boolean internalVerifySignature(byte[] byArray, byte[] byArray2) {
        MLDSAEngine mLDSAEngine = this.pubKey.getParameters().getEngine(this.random);
        mLDSAEngine.initVerify(this.pubKey.rho, this.pubKey.t1, false, null);
        SHAKEDigest sHAKEDigest = mLDSAEngine.getShake256Digest();
        sHAKEDigest.update(byArray, 0, byArray.length);
        return mLDSAEngine.verifyInternal(byArray2, byArray2.length, sHAKEDigest, this.pubKey.rho, this.pubKey.t1);
    }
}

