/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.parser;

import com.linkedin.coral.$internal.io.trino.sql.parser.AstBuilder;
import com.linkedin.coral.$internal.io.trino.sql.parser.CaseInsensitiveStream;
import com.linkedin.coral.$internal.io.trino.sql.parser.ErrorHandler;
import com.linkedin.coral.$internal.io.trino.sql.parser.ParsingException;
import com.linkedin.coral.$internal.io.trino.sql.parser.ParsingOptions;
import com.linkedin.coral.$internal.io.trino.sql.parser.SqlBaseBaseListener;
import com.linkedin.coral.$internal.io.trino.sql.parser.SqlBaseLexer;
import com.linkedin.coral.$internal.io.trino.sql.parser.SqlBaseParser;
import com.linkedin.coral.$internal.io.trino.sql.tree.DataType;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.PathSpecification;
import com.linkedin.coral.$internal.io.trino.sql.tree.Statement;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.BaseErrorListener;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.CharStream;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.CharStreams;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.CommonToken;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.CommonTokenStream;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.DefaultErrorStrategy;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.InputMismatchException;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.Parser;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.ParserRuleContext;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.RecognitionException;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.Recognizer;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.Token;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.TokenSource;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.atn.ParserATNSimulator;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.atn.PredictionMode;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.misc.Pair;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.misc.ParseCancellationException;
import com.linkedin.coral.$internal.org.antlr.v4.runtime.tree.TerminalNode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class SqlParser {
    private static final BaseErrorListener LEXER_ERROR_LISTENER = new BaseErrorListener(){

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine + 1);
        }
    };
    private static final BiConsumer<SqlBaseLexer, SqlBaseParser> DEFAULT_PARSER_INITIALIZER = (lexer, parser) -> {};
    private static final ErrorHandler PARSER_ERROR_HANDLER = ErrorHandler.builder().specialRule(35, "<expression>").specialRule(36, "<expression>").specialRule(38, "<expression>").specialRule(39, "<expression>").specialRule(37, "<predicate>").specialRule(70, "<identifier>").specialRule(41, "<string>").specialRule(5, "<query>").specialRule(49, "<type>").specialToken(231, "<integer>").ignoredRule(72).build();
    private final BiConsumer<SqlBaseLexer, SqlBaseParser> initializer;

    public SqlParser() {
        this(DEFAULT_PARSER_INITIALIZER);
    }

    public SqlParser(BiConsumer<SqlBaseLexer, SqlBaseParser> initializer) {
        this.initializer = Objects.requireNonNull(initializer, "initializer is null");
    }

    public Statement createStatement(String sql, ParsingOptions parsingOptions) {
        return (Statement)this.invokeParser("statement", sql, SqlBaseParser::singleStatement, parsingOptions);
    }

    public Expression createExpression(String expression, ParsingOptions parsingOptions) {
        return (Expression)this.invokeParser("expression", expression, SqlBaseParser::standaloneExpression, parsingOptions);
    }

    public DataType createType(String expression) {
        return (DataType)this.invokeParser("type", expression, SqlBaseParser::standaloneType, new ParsingOptions());
    }

    public PathSpecification createPathSpecification(String expression) {
        return (PathSpecification)this.invokeParser("path specification", expression, SqlBaseParser::standalonePathSpecification, new ParsingOptions());
    }

    private Node invokeParser(String name, String sql, Function<SqlBaseParser, ParserRuleContext> parseFunction, ParsingOptions parsingOptions) {
        try {
            ParserRuleContext tree;
            SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream(CharStreams.fromString(sql)));
            CommonTokenStream tokenStream = new CommonTokenStream(lexer);
            SqlBaseParser parser = new SqlBaseParser(tokenStream);
            this.initializer.accept(lexer, parser);
            parser.setErrorHandler(new DefaultErrorStrategy(){

                @Override
                public Token recoverInline(Parser recognizer) throws RecognitionException {
                    if (this.nextTokensContext == null) {
                        throw new InputMismatchException(recognizer);
                    }
                    throw new InputMismatchException(recognizer, this.nextTokensState, this.nextTokensContext);
                }
            });
            parser.addParseListener(new PostProcessor(Arrays.asList(parser.getRuleNames()), parser));
            lexer.removeErrorListeners();
            lexer.addErrorListener(LEXER_ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener(PARSER_ERROR_HANDLER);
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parseFunction.apply(parser);
            }
            catch (ParseCancellationException ex) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parseFunction.apply(parser);
            }
            return (Node)new AstBuilder(parsingOptions).visit(tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException(name + " is too large (stack overflow while parsing)");
        }
    }

    private static class PostProcessor
    extends SqlBaseBaseListener {
        private final List<String> ruleNames;
        private final SqlBaseParser parser;

        public PostProcessor(List<String> ruleNames, SqlBaseParser parser) {
            this.ruleNames = ruleNames;
            this.parser = parser;
        }

        @Override
        public void exitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
            Token token = context.QUOTED_IDENTIFIER().getSymbol();
            if (token.getText().length() == 2) {
                throw new ParsingException("Zero-length delimited identifier not allowed", null, token.getLine(), token.getCharPositionInLine() + 1);
            }
        }

        @Override
        public void exitBackQuotedIdentifier(SqlBaseParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers are not supported; use double quotes to quote identifiers", null, token.getLine(), token.getCharPositionInLine() + 1);
        }

        @Override
        public void exitDigitIdentifier(SqlBaseParser.DigitIdentifierContext context) {
            Token token = context.DIGIT_IDENTIFIER().getSymbol();
            throw new ParsingException("identifiers must not start with a digit; surround the identifier with double quotes", null, token.getLine(), token.getCharPositionInLine() + 1);
        }

        @Override
        public void exitNonReserved(SqlBaseParser.NonReservedContext context) {
            if (!(context.getChild(0) instanceof TerminalNode)) {
                int rule = ((ParserRuleContext)context.getChild(0)).getRuleIndex();
                throw new AssertionError((Object)("nonReserved can only contain tokens. Found nested rule: " + this.ruleNames.get(rule)));
            }
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            CommonToken newToken = new CommonToken(new Pair<TokenSource, CharStream>(token.getTokenSource(), token.getInputStream()), 234, token.getChannel(), token.getStartIndex(), token.getStopIndex());
            context.getParent().addChild(this.parser.createTerminalNode(context.getParent(), newToken));
        }
    }
}

