/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore;

import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.MetaStoreDirectSql;
import com.linkedin.coral.hive.metastore.api.BinaryColumnStatsData;
import com.linkedin.coral.hive.metastore.api.BooleanColumnStatsData;
import com.linkedin.coral.hive.metastore.api.ColumnStatisticsData;
import com.linkedin.coral.hive.metastore.api.ColumnStatisticsDesc;
import com.linkedin.coral.hive.metastore.api.ColumnStatisticsObj;
import com.linkedin.coral.hive.metastore.api.Date;
import com.linkedin.coral.hive.metastore.api.DateColumnStatsData;
import com.linkedin.coral.hive.metastore.api.Decimal;
import com.linkedin.coral.hive.metastore.api.DecimalColumnStatsData;
import com.linkedin.coral.hive.metastore.api.DoubleColumnStatsData;
import com.linkedin.coral.hive.metastore.api.InvalidObjectException;
import com.linkedin.coral.hive.metastore.api.LongColumnStatsData;
import com.linkedin.coral.hive.metastore.api.MetaException;
import com.linkedin.coral.hive.metastore.api.NoSuchObjectException;
import com.linkedin.coral.hive.metastore.api.StringColumnStatsData;
import com.linkedin.coral.hive.metastore.api.utils.DecimalUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class StatObjectConverter {
    public static .MTableColumnStatistics convertToMTableColumnStatistics(.MTable table, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj) throws NoSuchObjectException, MetaException, InvalidObjectException {
        if (statsObj == null || statsDesc == null) {
            throw new InvalidObjectException("Invalid column stats object");
        }
        .MTableColumnStatistics mColStats = new .MTableColumnStatistics();
        mColStats.setTable(table);
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setCatName(statsDesc.isSetCatName() ? statsDesc.getCatName() : "hive");
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetBitVectors() ? longStats.getBitVectors() : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetBitVectors() ? doubleStats.getBitVectors() : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? DecimalUtils.createJdoDecimalString((Decimal)decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? DecimalUtils.createJdoDecimalString((Decimal)decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, decimalStats.isSetBitVectors() ? decimalStats.getBitVectors() : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetBitVectors() ? stringStats.getBitVectors() : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStats = statsObj.getStatsData().getDateStats();
            mColStats.setDateStats(dateStats.isSetNumNulls() ? Long.valueOf(dateStats.getNumNulls()) : null, dateStats.isSetNumDVs() ? Long.valueOf(dateStats.getNumDVs()) : null, dateStats.isSetBitVectors() ? dateStats.getBitVectors() : null, dateStats.isSetLowValue() ? Long.valueOf(dateStats.getLowValue().getDaysSinceEpoch()) : null, dateStats.isSetHighValue() ? Long.valueOf(dateStats.getHighValue().getDaysSinceEpoch()) : null);
        }
        return mColStats;
    }

    public static void setFieldsIntoOldStats(.MTableColumnStatistics mStatsObj, .MTableColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue().longValue());
        }
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue().longValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue().doubleValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue().doubleValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen().longValue());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs().longValue());
        }
        if (mStatsObj.getBitVector() != null) {
            oldStatsObj.setBitVector(mStatsObj.getBitVector());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses().longValue());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues().longValue());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls().longValue());
        }
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
    }

    public static void setFieldsIntoOldStats(.MPartitionColumnStatistics mStatsObj, .MPartitionColumnStatistics oldStatsObj) {
        if (mStatsObj.getAvgColLen() != null) {
            oldStatsObj.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
        }
        if (mStatsObj.getLongHighValue() != null) {
            oldStatsObj.setLongHighValue(mStatsObj.getLongHighValue());
        }
        if (mStatsObj.getDoubleHighValue() != null) {
            oldStatsObj.setDoubleHighValue(mStatsObj.getDoubleHighValue());
        }
        oldStatsObj.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        if (mStatsObj.getLongLowValue() != null) {
            oldStatsObj.setLongLowValue(mStatsObj.getLongLowValue());
        }
        if (mStatsObj.getDoubleLowValue() != null) {
            oldStatsObj.setDoubleLowValue(mStatsObj.getDoubleLowValue());
        }
        if (mStatsObj.getDecimalLowValue() != null) {
            oldStatsObj.setDecimalLowValue(mStatsObj.getDecimalLowValue());
        }
        if (mStatsObj.getDecimalHighValue() != null) {
            oldStatsObj.setDecimalHighValue(mStatsObj.getDecimalHighValue());
        }
        if (mStatsObj.getMaxColLen() != null) {
            oldStatsObj.setMaxColLen(mStatsObj.getMaxColLen().longValue());
        }
        if (mStatsObj.getNumDVs() != null) {
            oldStatsObj.setNumDVs(mStatsObj.getNumDVs().longValue());
        }
        if (mStatsObj.getBitVector() != null) {
            oldStatsObj.setBitVector(mStatsObj.getBitVector());
        }
        if (mStatsObj.getNumFalses() != null) {
            oldStatsObj.setNumFalses(mStatsObj.getNumFalses().longValue());
        }
        if (mStatsObj.getNumTrues() != null) {
            oldStatsObj.setNumTrues(mStatsObj.getNumTrues().longValue());
        }
        if (mStatsObj.getNumNulls() != null) {
            oldStatsObj.setNumNulls(mStatsObj.getNumNulls().longValue());
        }
    }

    public static ColumnStatisticsObj getTableColumnStatisticsObj(.MTableColumnStatistics mStatsObj, boolean enableBitVector) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses());
            boolStats.setNumTrues(mStatsObj.getNumTrues());
            boolStats.setNumNulls(mStatsObj.getNumNulls());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            .StringColumnStatsDataInspector stringStats = new .StringColumnStatsDataInspector();
            stringStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen().longValue());
            stringStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            stringStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint") || colType.equals("timestamp")) {
            Long longLowValue;
            .LongColumnStatsDataInspector longStats = new .LongColumnStatsDataInspector();
            longStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            Long longHighValue = mStatsObj.getLongHighValue();
            if (longHighValue != null) {
                longStats.setHighValue(longHighValue.longValue());
            }
            if ((longLowValue = mStatsObj.getLongLowValue()) != null) {
                longStats.setLowValue(longLowValue.longValue());
            }
            longStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            longStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            Double doubleLowValue;
            .DoubleColumnStatsDataInspector doubleStats = new .DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            Double doubleHighValue = mStatsObj.getDoubleHighValue();
            if (doubleHighValue != null) {
                doubleStats.setHighValue(doubleHighValue.doubleValue());
            }
            if ((doubleLowValue = mStatsObj.getDoubleLowValue()) != null) {
                doubleStats.setLowValue(doubleLowValue.doubleValue());
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            doubleStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            String decimalLowValue;
            .DecimalColumnStatsDataInspector decimalStats = new .DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            String decimalHighValue = mStatsObj.getDecimalHighValue();
            if (decimalHighValue != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal((String)decimalHighValue));
            }
            if ((decimalLowValue = mStatsObj.getDecimalLowValue()) != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal((String)decimalLowValue));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            decimalStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            Long lowValue;
            .DateColumnStatsDataInspector dateStats = new .DateColumnStatsDataInspector();
            dateStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            Long highValue = mStatsObj.getLongHighValue();
            if (highValue != null) {
                dateStats.setHighValue(new Date(highValue));
            }
            if ((lowValue = mStatsObj.getLongLowValue()) != null) {
                dateStats.setLowValue(new Date(lowValue));
            }
            dateStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            dateStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDateStats((DateColumnStatsData)dateStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getTableColumnStatisticsDesc(.MTableColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(true);
        statsDesc.setCatName(mStatsObj.getCatName());
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static .MPartitionColumnStatistics convertToMPartitionColumnStatistics(.MPartition partition, ColumnStatisticsDesc statsDesc, ColumnStatisticsObj statsObj) throws MetaException, NoSuchObjectException {
        if (statsDesc == null || statsObj == null) {
            return null;
        }
        .MPartitionColumnStatistics mColStats = new .MPartitionColumnStatistics();
        mColStats.setPartition(partition);
        mColStats.setCatName(statsDesc.isSetCatName() ? statsDesc.getCatName() : "hive");
        mColStats.setDbName(statsDesc.getDbName());
        mColStats.setTableName(statsDesc.getTableName());
        mColStats.setPartitionName(statsDesc.getPartName());
        mColStats.setLastAnalyzed(statsDesc.getLastAnalyzed());
        mColStats.setColName(statsObj.getColName());
        mColStats.setColType(statsObj.getColType());
        if (statsObj.getStatsData().isSetBooleanStats()) {
            BooleanColumnStatsData boolStats = statsObj.getStatsData().getBooleanStats();
            mColStats.setBooleanStats(boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null, boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null, boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
        } else if (statsObj.getStatsData().isSetLongStats()) {
            LongColumnStatsData longStats = statsObj.getStatsData().getLongStats();
            mColStats.setLongStats(longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null, longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null, longStats.isSetBitVectors() ? longStats.getBitVectors() : null, longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null, longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = statsObj.getStatsData().getDoubleStats();
            mColStats.setDoubleStats(doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null, doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null, doubleStats.isSetBitVectors() ? doubleStats.getBitVectors() : null, doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null, doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
        } else if (statsObj.getStatsData().isSetDecimalStats()) {
            DecimalColumnStatsData decimalStats = statsObj.getStatsData().getDecimalStats();
            String low = decimalStats.isSetLowValue() ? DecimalUtils.createJdoDecimalString((Decimal)decimalStats.getLowValue()) : null;
            String high = decimalStats.isSetHighValue() ? DecimalUtils.createJdoDecimalString((Decimal)decimalStats.getHighValue()) : null;
            mColStats.setDecimalStats(decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null, decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null, decimalStats.isSetBitVectors() ? decimalStats.getBitVectors() : null, low, high);
        } else if (statsObj.getStatsData().isSetStringStats()) {
            StringColumnStatsData stringStats = statsObj.getStatsData().getStringStats();
            mColStats.setStringStats(stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null, stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null, stringStats.isSetBitVectors() ? stringStats.getBitVectors() : null, stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null, stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = statsObj.getStatsData().getBinaryStats();
            mColStats.setBinaryStats(binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null, binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null, binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
        } else if (statsObj.getStatsData().isSetDateStats()) {
            DateColumnStatsData dateStats = statsObj.getStatsData().getDateStats();
            mColStats.setDateStats(dateStats.isSetNumNulls() ? Long.valueOf(dateStats.getNumNulls()) : null, dateStats.isSetNumDVs() ? Long.valueOf(dateStats.getNumDVs()) : null, dateStats.isSetBitVectors() ? dateStats.getBitVectors() : null, dateStats.isSetLowValue() ? Long.valueOf(dateStats.getLowValue().getDaysSinceEpoch()) : null, dateStats.isSetHighValue() ? Long.valueOf(dateStats.getHighValue().getDaysSinceEpoch()) : null);
        }
        return mColStats;
    }

    public static ColumnStatisticsObj getPartitionColumnStatisticsObj(.MPartitionColumnStatistics mStatsObj, boolean enableBitVector) {
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColType(mStatsObj.getColType());
        statsObj.setColName(mStatsObj.getColName());
        String colType = mStatsObj.getColType().toLowerCase();
        ColumnStatisticsData colStatsData = new ColumnStatisticsData();
        if (colType.equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(mStatsObj.getNumFalses());
            boolStats.setNumTrues(mStatsObj.getNumTrues());
            boolStats.setNumNulls(mStatsObj.getNumNulls());
            colStatsData.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            .StringColumnStatsDataInspector stringStats = new .StringColumnStatsDataInspector();
            stringStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            stringStats.setAvgColLen(mStatsObj.getAvgColLen().doubleValue());
            stringStats.setMaxColLen(mStatsObj.getMaxColLen().longValue());
            stringStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            stringStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(mStatsObj.getNumNulls());
            binaryStats.setAvgColLen(mStatsObj.getAvgColLen());
            binaryStats.setMaxColLen(mStatsObj.getMaxColLen());
            colStatsData.setBinaryStats(binaryStats);
        } else if (colType.equals("tinyint") || colType.equals("smallint") || colType.equals("int") || colType.equals("bigint") || colType.equals("timestamp")) {
            .LongColumnStatsDataInspector longStats = new .LongColumnStatsDataInspector();
            longStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            if (mStatsObj.getLongHighValue() != null) {
                longStats.setHighValue(mStatsObj.getLongHighValue().longValue());
            }
            if (mStatsObj.getLongLowValue() != null) {
                longStats.setLowValue(mStatsObj.getLongLowValue().longValue());
            }
            longStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            longStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            .DoubleColumnStatsDataInspector doubleStats = new .DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            if (mStatsObj.getDoubleHighValue() != null) {
                doubleStats.setHighValue(mStatsObj.getDoubleHighValue().doubleValue());
            }
            if (mStatsObj.getDoubleLowValue() != null) {
                doubleStats.setLowValue(mStatsObj.getDoubleLowValue().doubleValue());
            }
            doubleStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            doubleStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            .DecimalColumnStatsDataInspector decimalStats = new .DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            if (mStatsObj.getDecimalHighValue() != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal((String)mStatsObj.getDecimalHighValue()));
            }
            if (mStatsObj.getDecimalLowValue() != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal((String)mStatsObj.getDecimalLowValue()));
            }
            decimalStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            decimalStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            .DateColumnStatsDataInspector dateStats = new .DateColumnStatsDataInspector();
            dateStats.setNumNulls(mStatsObj.getNumNulls().longValue());
            dateStats.setHighValue(new Date(mStatsObj.getLongHighValue()));
            dateStats.setLowValue(new Date(mStatsObj.getLongLowValue()));
            dateStats.setNumDVs(mStatsObj.getNumDVs().longValue());
            dateStats.setBitVectors(mStatsObj.getBitVector() == null || !enableBitVector ? null : mStatsObj.getBitVector());
            colStatsData.setDateStats((DateColumnStatsData)dateStats);
        }
        statsObj.setStatsData(colStatsData);
        return statsObj;
    }

    public static ColumnStatisticsDesc getPartitionColumnStatisticsDesc(.MPartitionColumnStatistics mStatsObj) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setIsTblLevel(false);
        statsDesc.setCatName(mStatsObj.getCatName());
        statsDesc.setDbName(mStatsObj.getDbName());
        statsDesc.setTableName(mStatsObj.getTableName());
        statsDesc.setPartName(mStatsObj.getPartitionName());
        statsDesc.setLastAnalyzed(mStatsObj.getLastAnalyzed());
        return statsDesc;
    }

    public static void fillColumnStatisticsData(String colType, ColumnStatisticsData data, Object llow, Object lhigh, Object dlow, Object dhigh, Object declow, Object dechigh, Object nulls, Object dist, Object bitVector, Object avglen, Object maxlen, Object trues, Object falses) throws MetaException {
        if ((colType = colType.toLowerCase()).equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(MetaStoreDirectSql.extractSqlLong(falses));
            boolStats.setNumTrues(MetaStoreDirectSql.extractSqlLong(trues));
            boolStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            data.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            .StringColumnStatsDataInspector stringStats = new .StringColumnStatsDataInspector();
            stringStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            stringStats.setAvgColLen(MetaStoreDirectSql.extractSqlDouble(avglen).doubleValue());
            stringStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen).longValue());
            stringStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            stringStats.setBitVectors(MetaStoreDirectSql.extractSqlBlob(bitVector));
            data.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            binaryStats.setAvgColLen(MetaStoreDirectSql.extractSqlDouble(avglen));
            binaryStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen));
            data.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint") || colType.equals("timestamp")) {
            .LongColumnStatsDataInspector longStats = new .LongColumnStatsDataInspector();
            longStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (lhigh != null) {
                longStats.setHighValue(MetaStoreDirectSql.extractSqlLong(lhigh).longValue());
            }
            if (llow != null) {
                longStats.setLowValue(MetaStoreDirectSql.extractSqlLong(llow).longValue());
            }
            longStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            longStats.setBitVectors(MetaStoreDirectSql.extractSqlBlob(bitVector));
            data.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            .DoubleColumnStatsDataInspector doubleStats = new .DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (dhigh != null) {
                doubleStats.setHighValue(MetaStoreDirectSql.extractSqlDouble(dhigh).doubleValue());
            }
            if (dlow != null) {
                doubleStats.setLowValue(MetaStoreDirectSql.extractSqlDouble(dlow).doubleValue());
            }
            doubleStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            doubleStats.setBitVectors(MetaStoreDirectSql.extractSqlBlob(bitVector));
            data.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            .DecimalColumnStatsDataInspector decimalStats = new .DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (dechigh != null) {
                decimalStats.setHighValue(DecimalUtils.createThriftDecimal((String)((String)dechigh)));
            }
            if (declow != null) {
                decimalStats.setLowValue(DecimalUtils.createThriftDecimal((String)((String)declow)));
            }
            decimalStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            decimalStats.setBitVectors(MetaStoreDirectSql.extractSqlBlob(bitVector));
            data.setDecimalStats((DecimalColumnStatsData)decimalStats);
        } else if (colType.equals("date")) {
            .DateColumnStatsDataInspector dateStats = new .DateColumnStatsDataInspector();
            dateStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (lhigh != null) {
                dateStats.setHighValue(new Date(MetaStoreDirectSql.extractSqlLong(lhigh)));
            }
            if (llow != null) {
                dateStats.setLowValue(new Date(MetaStoreDirectSql.extractSqlLong(llow)));
            }
            dateStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            dateStats.setBitVectors(MetaStoreDirectSql.extractSqlBlob(bitVector));
            data.setDateStats((DateColumnStatsData)dateStats);
        }
    }

    public static void fillColumnStatisticsData(String colType, ColumnStatisticsData data, Object llow, Object lhigh, Object dlow, Object dhigh, Object declow, Object dechigh, Object nulls, Object dist, Object avglen, Object maxlen, Object trues, Object falses, Object avgLong, Object avgDouble, Object avgDecimal, Object sumDist, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        if ((colType = colType.toLowerCase()).equals("boolean")) {
            BooleanColumnStatsData boolStats = new BooleanColumnStatsData();
            boolStats.setNumFalses(MetaStoreDirectSql.extractSqlLong(falses));
            boolStats.setNumTrues(MetaStoreDirectSql.extractSqlLong(trues));
            boolStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            data.setBooleanStats(boolStats);
        } else if (colType.equals("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
            .StringColumnStatsDataInspector stringStats = new .StringColumnStatsDataInspector();
            stringStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            stringStats.setAvgColLen(MetaStoreDirectSql.extractSqlDouble(avglen).doubleValue());
            stringStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen).longValue());
            stringStats.setNumDVs(MetaStoreDirectSql.extractSqlLong(dist).longValue());
            data.setStringStats((StringColumnStatsData)stringStats);
        } else if (colType.equals("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls));
            binaryStats.setAvgColLen(MetaStoreDirectSql.extractSqlDouble(avglen));
            binaryStats.setMaxColLen(MetaStoreDirectSql.extractSqlLong(maxlen));
            data.setBinaryStats(binaryStats);
        } else if (colType.equals("bigint") || colType.equals("int") || colType.equals("smallint") || colType.equals("tinyint") || colType.equals("timestamp")) {
            long estimation;
            .LongColumnStatsDataInspector longStats = new .LongColumnStatsDataInspector();
            longStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (lhigh != null) {
                longStats.setHighValue(MetaStoreDirectSql.extractSqlLong(lhigh).longValue());
            }
            if (llow != null) {
                longStats.setLowValue(MetaStoreDirectSql.extractSqlLong(llow).longValue());
            }
            long lowerBound = MetaStoreDirectSql.extractSqlLong(dist);
            long higherBound = MetaStoreDirectSql.extractSqlLong(sumDist);
            long rangeBound = Long.MAX_VALUE;
            if (lhigh != null && llow != null) {
                rangeBound = MetaStoreDirectSql.extractSqlLong(lhigh) - MetaStoreDirectSql.extractSqlLong(llow) + 1L;
            }
            if (useDensityFunctionForNDVEstimation && lhigh != null && llow != null && avgLong != null && MetaStoreDirectSql.extractSqlDouble(avgLong) != 0.0) {
                estimation = MetaStoreDirectSql.extractSqlLong((double)(MetaStoreDirectSql.extractSqlLong(lhigh) - MetaStoreDirectSql.extractSqlLong(llow)) / MetaStoreDirectSql.extractSqlDouble(avgLong));
                if (estimation < lowerBound) {
                    estimation = lowerBound;
                } else if (estimation > higherBound) {
                    estimation = higherBound;
                }
            } else {
                estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner);
            }
            estimation = Math.min(estimation, rangeBound);
            longStats.setNumDVs(estimation);
            data.setLongStats((LongColumnStatsData)longStats);
        } else if (colType.equals("date")) {
            long estimation;
            .DateColumnStatsDataInspector dateStats = new .DateColumnStatsDataInspector();
            dateStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (lhigh != null) {
                dateStats.setHighValue(new Date(MetaStoreDirectSql.extractSqlLong(lhigh)));
            }
            if (llow != null) {
                dateStats.setLowValue(new Date(MetaStoreDirectSql.extractSqlLong(llow)));
            }
            long lowerBound = MetaStoreDirectSql.extractSqlLong(dist);
            long higherBound = MetaStoreDirectSql.extractSqlLong(sumDist);
            long rangeBound = Long.MAX_VALUE;
            if (lhigh != null && llow != null) {
                rangeBound = MetaStoreDirectSql.extractSqlLong(lhigh) - MetaStoreDirectSql.extractSqlLong(llow) + 1L;
            }
            if (useDensityFunctionForNDVEstimation && lhigh != null && llow != null && avgLong != null && MetaStoreDirectSql.extractSqlDouble(avgLong) != 0.0) {
                estimation = MetaStoreDirectSql.extractSqlLong((double)(MetaStoreDirectSql.extractSqlLong(lhigh) - MetaStoreDirectSql.extractSqlLong(llow)) / MetaStoreDirectSql.extractSqlDouble(avgLong));
                if (estimation < lowerBound) {
                    estimation = lowerBound;
                } else if (estimation > higherBound) {
                    estimation = higherBound;
                }
            } else {
                estimation = (long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner);
            }
            estimation = Math.min(estimation, rangeBound);
            dateStats.setNumDVs(estimation);
            data.setDateStats((DateColumnStatsData)dateStats);
        } else if (colType.equals("double") || colType.equals("float")) {
            .DoubleColumnStatsDataInspector doubleStats = new .DoubleColumnStatsDataInspector();
            doubleStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            if (dhigh != null) {
                doubleStats.setHighValue(MetaStoreDirectSql.extractSqlDouble(dhigh).doubleValue());
            }
            if (dlow != null) {
                doubleStats.setLowValue(MetaStoreDirectSql.extractSqlDouble(dlow).doubleValue());
            }
            long lowerBound = MetaStoreDirectSql.extractSqlLong(dist);
            long higherBound = MetaStoreDirectSql.extractSqlLong(sumDist);
            if (useDensityFunctionForNDVEstimation && dhigh != null && dlow != null && avgDouble != null && MetaStoreDirectSql.extractSqlDouble(avgDouble) != 0.0) {
                long estimation = MetaStoreDirectSql.extractSqlLong((double)(MetaStoreDirectSql.extractSqlLong(dhigh) - MetaStoreDirectSql.extractSqlLong(dlow)) / MetaStoreDirectSql.extractSqlDouble(avgDouble));
                if (estimation < lowerBound) {
                    doubleStats.setNumDVs(lowerBound);
                } else if (estimation > higherBound) {
                    doubleStats.setNumDVs(higherBound);
                } else {
                    doubleStats.setNumDVs(estimation);
                }
            } else {
                doubleStats.setNumDVs((long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner));
            }
            data.setDoubleStats((DoubleColumnStatsData)doubleStats);
        } else if (colType.startsWith("decimal")) {
            .DecimalColumnStatsDataInspector decimalStats = new .DecimalColumnStatsDataInspector();
            decimalStats.setNumNulls(MetaStoreDirectSql.extractSqlLong(nulls).longValue());
            Decimal low = null;
            Decimal high = null;
            BigDecimal blow = null;
            BigDecimal bhigh = null;
            if (dechigh instanceof BigDecimal) {
                bhigh = (BigDecimal)dechigh;
                high = DecimalUtils.getDecimal((ByteBuffer)ByteBuffer.wrap(bhigh.unscaledValue().toByteArray()), (short)((short)bhigh.scale()));
            } else if (dechigh instanceof String) {
                bhigh = new BigDecimal((String)dechigh);
                high = DecimalUtils.createThriftDecimal((String)((String)dechigh));
            }
            decimalStats.setHighValue(high);
            if (declow instanceof BigDecimal) {
                blow = (BigDecimal)declow;
                low = DecimalUtils.getDecimal((ByteBuffer)ByteBuffer.wrap(blow.unscaledValue().toByteArray()), (short)((short)blow.scale()));
            } else if (dechigh instanceof String) {
                blow = new BigDecimal((String)declow);
                low = DecimalUtils.createThriftDecimal((String)((String)declow));
            }
            decimalStats.setLowValue(low);
            long lowerBound = MetaStoreDirectSql.extractSqlLong(dist);
            long higherBound = MetaStoreDirectSql.extractSqlLong(sumDist);
            if (useDensityFunctionForNDVEstimation && dechigh != null && declow != null && avgDecimal != null && MetaStoreDirectSql.extractSqlDouble(avgDecimal) != 0.0) {
                long estimation = MetaStoreDirectSql.extractSqlLong(MetaStoreDirectSql.extractSqlLong((double)bhigh.subtract(blow).floatValue() / MetaStoreDirectSql.extractSqlDouble(avgDecimal)));
                if (estimation < lowerBound) {
                    decimalStats.setNumDVs(lowerBound);
                } else if (estimation > higherBound) {
                    decimalStats.setNumDVs(higherBound);
                } else {
                    decimalStats.setNumDVs(estimation);
                }
            } else {
                decimalStats.setNumDVs((long)((double)lowerBound + (double)(higherBound - lowerBound) * ndvTuner));
            }
            data.setDecimalStats((DecimalColumnStatsData)decimalStats);
        }
    }

    public static void setFieldsIntoOldStats(ColumnStatisticsObj oldStatObj, ColumnStatisticsObj newStatObj) {
        ColumnStatisticsData._Fields typeOld;
        ColumnStatisticsData._Fields typeNew = (ColumnStatisticsData._Fields)newStatObj.getStatsData().getSetField();
        typeNew = typeNew == (typeOld = (ColumnStatisticsData._Fields)oldStatObj.getStatsData().getSetField()) ? typeNew : null;
        switch (typeNew) {
            case BOOLEAN_STATS: {
                BooleanColumnStatsData oldBooleanStatsData = oldStatObj.getStatsData().getBooleanStats();
                BooleanColumnStatsData newBooleanStatsData = newStatObj.getStatsData().getBooleanStats();
                if (newBooleanStatsData.isSetNumTrues()) {
                    oldBooleanStatsData.setNumTrues(newBooleanStatsData.getNumTrues());
                }
                if (newBooleanStatsData.isSetNumFalses()) {
                    oldBooleanStatsData.setNumFalses(newBooleanStatsData.getNumFalses());
                }
                if (newBooleanStatsData.isSetNumNulls()) {
                    oldBooleanStatsData.setNumNulls(newBooleanStatsData.getNumNulls());
                }
                if (!newBooleanStatsData.isSetBitVectors()) break;
                oldBooleanStatsData.setBitVectors(newBooleanStatsData.getBitVectors());
                break;
            }
            case LONG_STATS: {
                LongColumnStatsData oldLongStatsData = oldStatObj.getStatsData().getLongStats();
                LongColumnStatsData newLongStatsData = newStatObj.getStatsData().getLongStats();
                if (newLongStatsData.isSetHighValue()) {
                    oldLongStatsData.setHighValue(newLongStatsData.getHighValue());
                }
                if (newLongStatsData.isSetLowValue()) {
                    oldLongStatsData.setLowValue(newLongStatsData.getLowValue());
                }
                if (newLongStatsData.isSetNumNulls()) {
                    oldLongStatsData.setNumNulls(newLongStatsData.getNumNulls());
                }
                if (newLongStatsData.isSetNumDVs()) {
                    oldLongStatsData.setNumDVs(newLongStatsData.getNumDVs());
                }
                if (!newLongStatsData.isSetBitVectors()) break;
                oldLongStatsData.setBitVectors(newLongStatsData.getBitVectors());
                break;
            }
            case DOUBLE_STATS: {
                DoubleColumnStatsData oldDoubleStatsData = oldStatObj.getStatsData().getDoubleStats();
                DoubleColumnStatsData newDoubleStatsData = newStatObj.getStatsData().getDoubleStats();
                if (newDoubleStatsData.isSetHighValue()) {
                    oldDoubleStatsData.setHighValue(newDoubleStatsData.getHighValue());
                }
                if (newDoubleStatsData.isSetLowValue()) {
                    oldDoubleStatsData.setLowValue(newDoubleStatsData.getLowValue());
                }
                if (newDoubleStatsData.isSetNumNulls()) {
                    oldDoubleStatsData.setNumNulls(newDoubleStatsData.getNumNulls());
                }
                if (newDoubleStatsData.isSetNumDVs()) {
                    oldDoubleStatsData.setNumDVs(newDoubleStatsData.getNumDVs());
                }
                if (!newDoubleStatsData.isSetBitVectors()) break;
                oldDoubleStatsData.setBitVectors(newDoubleStatsData.getBitVectors());
                break;
            }
            case STRING_STATS: {
                StringColumnStatsData oldStringStatsData = oldStatObj.getStatsData().getStringStats();
                StringColumnStatsData newStringStatsData = newStatObj.getStatsData().getStringStats();
                if (newStringStatsData.isSetMaxColLen()) {
                    oldStringStatsData.setMaxColLen(newStringStatsData.getMaxColLen());
                }
                if (newStringStatsData.isSetAvgColLen()) {
                    oldStringStatsData.setAvgColLen(newStringStatsData.getAvgColLen());
                }
                if (newStringStatsData.isSetNumNulls()) {
                    oldStringStatsData.setNumNulls(newStringStatsData.getNumNulls());
                }
                if (newStringStatsData.isSetNumDVs()) {
                    oldStringStatsData.setNumDVs(newStringStatsData.getNumDVs());
                }
                if (!newStringStatsData.isSetBitVectors()) break;
                oldStringStatsData.setBitVectors(newStringStatsData.getBitVectors());
                break;
            }
            case BINARY_STATS: {
                BinaryColumnStatsData oldBinaryStatsData = oldStatObj.getStatsData().getBinaryStats();
                BinaryColumnStatsData newBinaryStatsData = newStatObj.getStatsData().getBinaryStats();
                if (newBinaryStatsData.isSetMaxColLen()) {
                    oldBinaryStatsData.setMaxColLen(newBinaryStatsData.getMaxColLen());
                }
                if (newBinaryStatsData.isSetAvgColLen()) {
                    oldBinaryStatsData.setAvgColLen(newBinaryStatsData.getAvgColLen());
                }
                if (newBinaryStatsData.isSetNumNulls()) {
                    oldBinaryStatsData.setNumNulls(newBinaryStatsData.getNumNulls());
                }
                if (!newBinaryStatsData.isSetBitVectors()) break;
                oldBinaryStatsData.setBitVectors(newBinaryStatsData.getBitVectors());
                break;
            }
            case DECIMAL_STATS: {
                DecimalColumnStatsData oldDecimalStatsData = oldStatObj.getStatsData().getDecimalStats();
                DecimalColumnStatsData newDecimalStatsData = newStatObj.getStatsData().getDecimalStats();
                if (newDecimalStatsData.isSetHighValue()) {
                    oldDecimalStatsData.setHighValue(newDecimalStatsData.getHighValue());
                }
                if (newDecimalStatsData.isSetLowValue()) {
                    oldDecimalStatsData.setLowValue(newDecimalStatsData.getLowValue());
                }
                if (newDecimalStatsData.isSetNumNulls()) {
                    oldDecimalStatsData.setNumNulls(newDecimalStatsData.getNumNulls());
                }
                if (newDecimalStatsData.isSetNumDVs()) {
                    oldDecimalStatsData.setNumDVs(newDecimalStatsData.getNumDVs());
                }
                if (!newDecimalStatsData.isSetBitVectors()) break;
                oldDecimalStatsData.setBitVectors(newDecimalStatsData.getBitVectors());
                break;
            }
            case DATE_STATS: {
                DateColumnStatsData oldDateStatsData = oldStatObj.getStatsData().getDateStats();
                DateColumnStatsData newDateStatsData = newStatObj.getStatsData().getDateStats();
                if (newDateStatsData.isSetHighValue()) {
                    oldDateStatsData.setHighValue(newDateStatsData.getHighValue());
                }
                if (newDateStatsData.isSetLowValue()) {
                    oldDateStatsData.setLowValue(newDateStatsData.getLowValue());
                }
                if (newDateStatsData.isSetNumNulls()) {
                    oldDateStatsData.setNumNulls(newDateStatsData.getNumNulls());
                }
                if (newDateStatsData.isSetNumDVs()) {
                    oldDateStatsData.setNumDVs(newDateStatsData.getNumDVs());
                }
                if (!newDateStatsData.isSetBitVectors()) break;
                oldDateStatsData.setBitVectors(newDateStatsData.getBitVectors());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stats type: " + typeNew.toString());
            }
        }
    }
}

