/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.DoubleWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import java.nio.charset.CharacterCodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyDouble
extends LazyPrimitive<LazyDoubleObjectInspector, DoubleWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyDouble.class);

    public LazyDouble(LazyDoubleObjectInspector oi) {
        super(oi);
        this.data = new DoubleWritable();
    }

    public LazyDouble(LazyDouble copy) {
        super(copy);
        this.data = new DoubleWritable(((DoubleWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            byteData = Text.decode(bytes.getData(), start, length);
            ((DoubleWritable)this.data).set(Double.parseDouble(byteData));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            LOG.debug("Data not in the Double data type range so converted to null. Given data is :" + byteData, (Throwable)e);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug("Data not in the Double data type range so converted to null.", (Throwable)e);
        }
    }
}

