/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveChar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyHiveChar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.BaseCharUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;

public class LazyHiveCharObjectInspector
extends AbstractPrimitiveLazyObjectInspector<HiveCharWritable>
implements HiveCharObjectInspector {
    private boolean escaped;
    private byte escapeChar;

    public LazyHiveCharObjectInspector() {
    }

    public LazyHiveCharObjectInspector(CharTypeInfo typeInfo) {
        this(typeInfo, false, 0);
    }

    public LazyHiveCharObjectInspector(CharTypeInfo typeInfo, boolean escaped, byte escapeChar) {
        super(typeInfo);
        this.escaped = escaped;
        this.escapeChar = escapeChar;
    }

    @Override
    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        LazyHiveChar ret = new LazyHiveChar(this);
        ret.setValue((LazyHiveChar)o);
        return ret;
    }

    @Override
    public HiveChar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveChar ret = ((HiveCharWritable)((LazyHiveChar)o).getWritableObject()).getHiveChar();
        if (!BaseCharUtils.doesPrimitiveMatchTypeParams(ret, (CharTypeInfo)this.typeInfo)) {
            HiveChar newValue = new HiveChar(ret, ((CharTypeInfo)this.typeInfo).getLength());
            return newValue;
        }
        return ret;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }

    public String toString() {
        return this.getTypeName();
    }
}

