/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveVarchar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.DoubleWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.BaseCharUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.io.BooleanWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.FloatWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.IntWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.LongWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableHiveVarcharObjectInspector
extends AbstractPrimitiveWritableObjectInspector
implements SettableHiveVarcharObjectInspector {
    private static final Logger LOG = LoggerFactory.getLogger(WritableHiveVarcharObjectInspector.class);

    public WritableHiveVarcharObjectInspector() {
    }

    public WritableHiveVarcharObjectInspector(VarcharTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveVarchar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text || o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            String str = o.toString();
            return new HiveVarchar(str, ((VarcharTypeInfo)this.typeInfo).getLength());
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams(writable)) {
            return writable.getHiveVarchar();
        }
        return this.getPrimitiveWithParams(writable);
    }

    @Override
    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text || o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            String str = o.toString();
            HiveVarcharWritable hcw = new HiveVarcharWritable();
            hcw.set(str, ((VarcharTypeInfo)this.typeInfo).getLength());
            return hcw;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveVarcharWritable)o)) {
            return writable;
        }
        return this.getWritableWithParams(writable);
    }

    private HiveVarchar getPrimitiveWithParams(HiveVarcharWritable val) {
        HiveVarchar hv = new HiveVarchar();
        hv.setValue(val.getHiveVarchar(), this.getMaxLength());
        return hv;
    }

    private HiveVarcharWritable getWritableWithParams(HiveVarcharWritable val) {
        HiveVarcharWritable newValue = new HiveVarcharWritable();
        newValue.set(val, this.getMaxLength());
        return newValue;
    }

    private boolean doesWritableMatchTypeParams(HiveVarcharWritable writable) {
        return BaseCharUtils.doesWritableMatchTypeParams(writable, (VarcharTypeInfo)this.typeInfo);
    }

    @Override
    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Text) {
            String str = ((Text)o).toString();
            HiveVarcharWritable hcw = new HiveVarcharWritable();
            hcw.set(str, ((VarcharTypeInfo)this.typeInfo).getLength());
            return hcw;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        if (this.doesWritableMatchTypeParams((HiveVarcharWritable)o)) {
            return new HiveVarcharWritable(writable);
        }
        return this.getWritableWithParams(writable);
    }

    @Override
    public Object set(Object o, HiveVarchar value) {
        if (value == null) {
            return null;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object set(Object o, String value) {
        if (value == null) {
            return null;
        }
        HiveVarcharWritable writable = (HiveVarcharWritable)o;
        writable.set(value, this.getMaxLength());
        return o;
    }

    @Override
    public Object create(HiveVarchar value) {
        HiveVarcharWritable ret = new HiveVarcharWritable();
        ret.set(value, this.getMaxLength());
        return ret;
    }

    public int getMaxLength() {
        return ((VarcharTypeInfo)this.typeInfo).getLength();
    }
}

