/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles;

import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.quantiles.DoublesBufferAccessor;
import java.util.Arrays;

final class DoublesArrayAccessor
extends DoublesBufferAccessor {
    private int numItems_;
    private double[] buffer_;

    private DoublesArrayAccessor(double[] buffer) {
        this.numItems_ = buffer.length;
        this.buffer_ = buffer;
    }

    static DoublesArrayAccessor wrap(double[] buffer) {
        return new DoublesArrayAccessor(buffer);
    }

    static DoublesArrayAccessor initialize(int numItems) {
        return new DoublesArrayAccessor(new double[numItems]);
    }

    @Override
    double get(int index) {
        assert (index >= 0 && index < this.numItems_);
        return this.buffer_[index];
    }

    @Override
    double set(int index, double value) {
        assert (index >= 0 && index < this.numItems_);
        double retVal = this.buffer_[index];
        this.buffer_[index] = value;
        return retVal;
    }

    @Override
    int numItems() {
        return this.numItems_;
    }

    @Override
    double[] getArray(int fromIdx, int numItems) {
        return Arrays.copyOfRange(this.buffer_, fromIdx, fromIdx + numItems);
    }

    @Override
    void putArray(double[] srcArray, int srcIndex, int dstIndex, int numItems) {
        System.arraycopy(srcArray, srcIndex, this.buffer_, dstIndex, numItems);
    }
}

