/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple;

import com.linkedin.coral.calcite.$internal.com.yahoo.memory.Memory;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesQuickSelectSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.linkedin.coral.calcite.$internal.com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesUnion {
    final int nomEntries_;
    final int numValues_;
    final long seed_;
    final short seedHash_;
    ArrayOfDoublesQuickSelectSketch sketch_;
    long theta_;

    ArrayOfDoublesUnion(ArrayOfDoublesQuickSelectSketch sketch) {
        this.nomEntries_ = sketch.getNominalEntries();
        this.numValues_ = sketch.getNumValues();
        this.seed_ = sketch.getSeed();
        this.seedHash_ = Util.computeSeedHash(this.seed_);
        this.sketch_ = sketch;
        this.theta_ = sketch.getThetaLong();
    }

    public void update(ArrayOfDoublesSketch sketchIn) {
        if (sketchIn == null) {
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        if (sketchIn.isEmpty()) {
            return;
        }
        if (sketchIn.getThetaLong() < this.theta_) {
            this.theta_ = sketchIn.getThetaLong();
        }
        ArrayOfDoublesSketchIterator it = sketchIn.iterator();
        while (it.next()) {
            this.sketch_.merge(it.getKey(), it.getValues());
        }
    }

    public ArrayOfDoublesCompactSketch getResult(Memory mem) {
        this.trim();
        return this.sketch_.compact(mem);
    }

    public ArrayOfDoublesCompactSketch getResult() {
        return this.getResult(null);
    }

    public abstract void reset();

    public byte[] toByteArray() {
        this.trim();
        return this.sketch_.toByteArray();
    }

    public static int getMaxBytes(int nomEntries, int numValues) {
        return ArrayOfDoublesQuickSelectSketch.getMaxBytes(nomEntries, numValues);
    }

    private void trim() {
        this.sketch_.trim();
        if (this.theta_ < this.sketch_.getThetaLong()) {
            this.sketch_.setThetaLong(this.theta_);
            this.sketch_.rebuild();
        }
    }
}

