/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import com.linkedin.coral.common.TypeConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;

public class LocalMetastoreHiveTable
implements ScannableTable {
    private final String tableName;
    private final List<String> columnInfo;

    public LocalMetastoreHiveTable(String tableName, List<String> columnInfo) {
        this.tableName = tableName;
        this.columnInfo = columnInfo;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.tableName != null && this.columnInfo != null) {
            ArrayList<RelDataType> fieldTypes = new ArrayList<RelDataType>(this.columnInfo.size());
            ArrayList<String> fieldNames = new ArrayList<String>(this.columnInfo.size());
            this.columnInfo.forEach(col -> {
                String[] info = col.split("\\|");
                String colName = info[0];
                String colType = info[1];
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(colType);
                RelDataType relType = TypeConverter.convert(typeInfo, typeFactory);
                if (!fieldNames.contains(colName)) {
                    fieldNames.add(colName);
                    fieldTypes.add(relType);
                }
            });
            return typeFactory.createStructType(fieldTypes, fieldNames);
        }
        return null;
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    @Override
    public boolean isRolledUp(String s2) {
        return false;
    }

    @Override
    public boolean rolledUpColumnValidInsideAgg(String s2, SqlCall sqlCall, SqlNode sqlNode, CalciteConnectionConfig calciteConnectionConfig) {
        return true;
    }

    @Override
    public Enumerable<Object[]> scan(DataContext dataContext) {
        throw new RuntimeException("Calcite runtime is not supported");
    }
}

