/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.hive.hive2rel.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public class CoalesceStructUtility {
    public static final SqlReturnTypeInference COALESCE_STRUCT_FUNCTION_RETURN_STRATEGY = ReturnTypes.cascade(opBinding -> {
        int numArgs = opBinding.getOperandCount();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        Preconditions.checkState((numArgs == 1 || numArgs == 2 ? 1 : 0) != 0);
        RelDataType coalescedDataType = CoalesceStructUtility.coalesce(opBinding.getOperandType(0), typeFactory);
        if (numArgs == 1) {
            return coalescedDataType;
        }
        int ordinal = opBinding.getOperandLiteralValue(1, Integer.class);
        return coalescedDataType.getFieldList().get(ordinal).getType();
    }, SqlTypeTransforms.TO_NULLABLE);
    private static final String TRINO_PREFIX = "field";
    private static final String HIVE_EXTRACT_UNION_PREFIX = "tag_";

    private CoalesceStructUtility() {
    }

    @VisibleForTesting
    static RelDataType coalesce(RelDataType inputNode, RelDataTypeFactory typeFactory) {
        if (inputNode.isStruct()) {
            List<String> fieldNames = inputNode.getFieldNames();
            return CoalesceStructUtility.coalesceStruct(inputNode, CoalesceStructUtility.isTrinoStructPattern(fieldNames), typeFactory);
        }
        if (inputNode.getKeyType() != null) {
            return CoalesceStructUtility.coalesceMap(inputNode, typeFactory);
        }
        if (inputNode.getComponentType() != null) {
            return CoalesceStructUtility.coalesceCollection(inputNode, typeFactory);
        }
        return inputNode;
    }

    private static RelDataType coalesceStruct(RelDataType inputNode, boolean coalesceRequired, RelDataTypeFactory typeFactory) {
        int i;
        List<String> originalNames = inputNode.getFieldNames();
        List<String> convertedNames = coalesceRequired ? originalNames.stream().map(x -> x.replaceFirst(TRINO_PREFIX, HIVE_EXTRACT_UNION_PREFIX)).collect(Collectors.toList()).subList(1, originalNames.size()) : originalNames;
        List originalTypes = inputNode.getFieldList().stream().map(RelDataTypeField::getType).collect(Collectors.toList());
        ArrayList<RelDataType> convertedTypes = new ArrayList<RelDataType>(coalesceRequired ? originalTypes.size() - 1 : originalTypes.size());
        int n = i = coalesceRequired ? 1 : 0;
        while (i < originalTypes.size()) {
            convertedTypes.add(CoalesceStructUtility.coalesce((RelDataType)originalTypes.get(i), typeFactory));
            ++i;
        }
        RelDataType structType = typeFactory.createStructType(convertedTypes, convertedNames);
        return typeFactory.createTypeWithNullability(structType, true);
    }

    private static RelDataType coalesceMap(RelDataType inputNode, RelDataTypeFactory typeFactory) {
        RelDataType coalescedKeyType = CoalesceStructUtility.coalesce(inputNode.getKeyType(), typeFactory);
        RelDataType coalescedValueType = CoalesceStructUtility.coalesce(inputNode.getValueType(), typeFactory);
        RelDataType mapType = typeFactory.createMapType(coalescedKeyType, coalescedValueType);
        return typeFactory.createTypeWithNullability(mapType, true);
    }

    private static RelDataType coalesceCollection(RelDataType inputNode, RelDataTypeFactory typeFactory) {
        RelDataType coalescedComponentType = CoalesceStructUtility.coalesce(inputNode.getComponentType(), typeFactory);
        RelDataType arrayType = typeFactory.createArrayType(coalescedComponentType, -1L);
        return typeFactory.createTypeWithNullability(arrayType, true);
    }

    @VisibleForTesting
    static boolean isTrinoStructPattern(List<String> fieldNames) {
        if (fieldNames.isEmpty() || !fieldNames.get(0).equals("tag")) {
            return false;
        }
        boolean flag = true;
        StringBuilder fieldNameRef = new StringBuilder(TRINO_PREFIX);
        for (int i = 1; i < fieldNames.size(); ++i) {
            int index = i - 1;
            fieldNameRef.append(index);
            if (!fieldNameRef.toString().equals(fieldNames.get(i))) {
                flag = false;
                break;
            }
            fieldNameRef.delete(5, fieldNameRef.length());
        }
        return flag;
    }
}

