/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableSet;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;

public class CastOperatorTransformer
extends SqlCallTransformer {
    private static final String WITH_TIMEZONE = "with_timezone";
    private static final String TO_UNIXTIME = "to_unixtime";
    private static final Set<SqlTypeName> BINARY_SQL_TYPE_NAMES = ImmutableSet.of(SqlTypeName.VARBINARY, SqlTypeName.BINARY);
    private static final Set<SqlTypeName> CHAR_SQL_TYPE_NAMES = ImmutableSet.of(SqlTypeName.VARCHAR, SqlTypeName.CHAR);

    public CastOperatorTransformer(TypeDerivationUtil typeDerivationUtil) {
        super(typeDerivationUtil);
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getKind() == SqlKind.CAST;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> operands = sqlCall.getOperandList();
        SqlNode leftOperand = operands.get(0);
        RelDataType sourceType = this.deriveRelDatatype(leftOperand);
        SqlDataTypeSpec targetSqlDataTypeSpec = (SqlDataTypeSpec)operands.get(1);
        SqlTypeName targetType = SqlTypeName.get(targetSqlDataTypeSpec.getTypeNameSpec().getTypeName().toString());
        if (sourceType.getSqlTypeName() == SqlTypeName.TIMESTAMP && targetType == SqlTypeName.DECIMAL) {
            SqlOperator trinoWithTimeZone = CastOperatorTransformer.createSqlOperator(WITH_TIMEZONE, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
            SqlOperator trinoToUnixTime = CastOperatorTransformer.createSqlOperator(TO_UNIXTIME, ReturnTypes.explicit(SqlTypeName.DOUBLE));
            SqlCall withTimeZoneCall = trinoWithTimeZone.createCall(SqlParserPos.ZERO, leftOperand, CalciteUtil.createStringLiteral("UTC", SqlParserPos.ZERO));
            SqlCall toUnixTimeCall = trinoToUnixTime.createCall(SqlParserPos.ZERO, withTimeZoneCall);
            return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, toUnixTimeCall, targetSqlDataTypeSpec);
        }
        if (BINARY_SQL_TYPE_NAMES.contains((Object)sourceType.getSqlTypeName()) && CHAR_SQL_TYPE_NAMES.contains((Object)targetType)) {
            SqlOperator fromUTF8 = CastOperatorTransformer.createSqlOperator("from_utf8", ReturnTypes.explicit(SqlTypeName.VARCHAR));
            return fromUTF8.createCall(SqlParserPos.ZERO, leftOperand);
        }
        return sqlCall;
    }
}

