/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.functions.FunctionReturnTypes;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;

public class FromUnixtimeOperatorTransformer
extends SqlCallTransformer {
    private static final String FORMAT_DATETIME = "format_datetime";
    private static final String FROM_UNIXTIME = "from_unixtime";

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getName().equalsIgnoreCase(FROM_UNIXTIME);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        SqlOperator formatDatetimeOperator = FromUnixtimeOperatorTransformer.createSqlOperator(FORMAT_DATETIME, FunctionReturnTypes.STRING);
        SqlOperator fromUnixtimeOperator = FromUnixtimeOperatorTransformer.createSqlOperator(FROM_UNIXTIME, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
        List<SqlNode> operands = sqlCall.getOperandList();
        if (operands.size() == 1) {
            return formatDatetimeOperator.createCall(SqlParserPos.ZERO, fromUnixtimeOperator.createCall(SqlParserPos.ZERO, operands.get(0)), SqlLiteral.createCharString("yyyy-MM-dd HH:mm:ss", SqlParserPos.ZERO));
        }
        if (operands.size() == 2) {
            return formatDatetimeOperator.createCall(SqlParserPos.ZERO, fromUnixtimeOperator.createCall(SqlParserPos.ZERO, operands.get(0)), operands.get(1));
        }
        return sqlCall;
    }
}

