/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.HiveTypeSystem;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class FromUtcTimestampOperatorTransformer
extends SqlCallTransformer {
    private static final Set<SqlTypeName> INT_SQL_TYPE_NAMES = new HashSet<SqlTypeName>(Arrays.asList(SqlTypeName.BIGINT, SqlTypeName.INTEGER, SqlTypeName.SMALLINT, SqlTypeName.TINYINT));
    private static final Set<SqlTypeName> DECIMAL_SQL_TYPE_NAMES = new HashSet<SqlTypeName>(Arrays.asList(SqlTypeName.DOUBLE, SqlTypeName.FLOAT, SqlTypeName.DECIMAL));
    private static final Set<SqlTypeName> TIMESTAMP_SQL_TYPE_NAMES = new HashSet<SqlTypeName>(Arrays.asList(SqlTypeName.TIMESTAMP, SqlTypeName.DATE));
    private static final String FROM_UTC_TIMESTAMP = "from_utc_timestamp";
    private static final String AT_TIMEZONE = "at_timezone";
    private static final String WITH_TIMEZONE = "with_timezone";
    private static final String TO_UNIXTIME = "to_unixtime";
    private static final String FROM_UNIXTIME_NANOS = "from_unixtime_nanos";
    private static final String TIMESTAMP_FROM_UNIXTIME = "timestamp_from_unixtime";
    private static final String CANONICALIZE_HIVE_TIMEZONE_ID = "$canonicalize_hive_timezone_id";

    public FromUtcTimestampOperatorTransformer(TypeDerivationUtil typeDerivationUtil) {
        super(typeDerivationUtil);
    }

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().getName().equalsIgnoreCase(FROM_UTC_TIMESTAMP);
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> operands = sqlCall.getOperandList();
        SqlNode sourceValue = operands.get(0);
        SqlNode timezone = operands.get(1);
        BasicSqlType targetType = new BasicSqlType(new HiveTypeSystem(), SqlTypeName.TIMESTAMP, 3);
        RelDataType inputType = this.deriveRelDatatype(sqlCall.getOperandList().get(0));
        SqlTypeName inputSqlTypeName = inputType.getSqlTypeName();
        SqlOperator trinoAtTimeZone = FromUtcTimestampOperatorTransformer.createSqlOperator(AT_TIMEZONE, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
        SqlOperator trinoWithTimeZone = FromUtcTimestampOperatorTransformer.createSqlOperator(WITH_TIMEZONE, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
        SqlOperator trinoToUnixTime = FromUtcTimestampOperatorTransformer.createSqlOperator(TO_UNIXTIME, ReturnTypes.explicit(SqlTypeName.DOUBLE));
        SqlOperator trinoFromUnixtimeNanos = FromUtcTimestampOperatorTransformer.createSqlOperator(FROM_UNIXTIME_NANOS, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
        SqlOperator trinoFromUnixTime = FromUtcTimestampOperatorTransformer.createSqlOperator(TIMESTAMP_FROM_UNIXTIME, ReturnTypes.explicit(SqlTypeName.TIMESTAMP));
        SqlOperator trinoCanonicalizeHiveTimezoneId = FromUtcTimestampOperatorTransformer.createSqlOperator(CANONICALIZE_HIVE_TIMEZONE_ID, ReturnTypes.explicit(SqlTypeName.VARCHAR));
        SqlCall canonicalizeHiveTimezoneIdSqlCall = trinoCanonicalizeHiveTimezoneId.createCall(SqlParserPos.ZERO, timezone);
        if (INT_SQL_TYPE_NAMES.contains((Object)inputSqlTypeName)) {
            SqlCall castedOperandCall = this.castOperand(sourceValue, new BasicSqlType(new HiveTypeSystem(), SqlTypeName.BIGINT));
            SqlCall multipliedValueCall = SqlStdOperatorTable.MULTIPLY.createCall(SqlParserPos.ZERO, castedOperandCall, CalciteUtil.createLiteralNumber(1000000L, SqlParserPos.ZERO));
            SqlCall fromUnixtimeNanosCall = trinoFromUnixtimeNanos.createCall(SqlParserPos.ZERO, multipliedValueCall);
            SqlCall atTimeZoneCall = trinoAtTimeZone.createCall(SqlParserPos.ZERO, fromUnixtimeNanosCall, canonicalizeHiveTimezoneIdSqlCall);
            return this.castOperand(atTimeZoneCall, targetType);
        }
        if (DECIMAL_SQL_TYPE_NAMES.contains((Object)inputSqlTypeName)) {
            SqlCall castedOperandCall = this.castOperand(sourceValue, new BasicSqlType(new HiveTypeSystem(), SqlTypeName.DOUBLE));
            SqlCall fromUnixTimeCall = trinoFromUnixTime.createCall(SqlParserPos.ZERO, castedOperandCall);
            SqlCall atTimeZoneCall = trinoAtTimeZone.createCall(SqlParserPos.ZERO, fromUnixTimeCall, canonicalizeHiveTimezoneIdSqlCall);
            return this.castOperand(atTimeZoneCall, targetType);
        }
        if (TIMESTAMP_SQL_TYPE_NAMES.contains((Object)inputSqlTypeName)) {
            SqlCall withTimeZoneCall = trinoWithTimeZone.createCall(SqlParserPos.ZERO, sourceValue, CalciteUtil.createStringLiteral("UTC", SqlParserPos.ZERO));
            SqlCall toUnixTimeCall = trinoToUnixTime.createCall(SqlParserPos.ZERO, withTimeZoneCall);
            SqlCall fromUnixTimeCall = trinoFromUnixTime.createCall(SqlParserPos.ZERO, toUnixTimeCall);
            SqlCall atTimeZoneCall = trinoAtTimeZone.createCall(SqlParserPos.ZERO, fromUnixTimeCall, canonicalizeHiveTimezoneIdSqlCall);
            return this.castOperand(atTimeZoneCall, targetType);
        }
        return sqlCall;
    }

    private SqlCall castOperand(SqlNode operand, RelDataType relDataType) {
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, operand, SqlTypeUtil.convertTypeToSpec(relDataType));
    }
}

