/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableSet;
import com.linkedin.coral.common.calcite.CalciteUtil;
import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class SubstrIndexTransformer
extends SqlCallTransformer {
    private static final Set<String> SUBSTRING_OPERATORS = ImmutableSet.of("substr", "substring");

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return SUBSTRING_OPERATORS.contains(sqlCall.getOperator().getName().toLowerCase());
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        List<SqlNode> operandList = sqlCall.getOperandList();
        SqlNode start = operandList.get(1);
        if (start instanceof SqlNumericLiteral) {
            int startInt = ((SqlNumericLiteral)operandList.get(1)).getValueAs(Integer.class);
            if (startInt == 0) {
                SqlNumericLiteral newStart = SqlNumericLiteral.createExactNumeric(String.valueOf(1), SqlImplementor.POS);
                sqlCall.setOperand(1, newStart);
            }
        } else if (start instanceof SqlIdentifier) {
            List<SqlNode> whenClauses = Arrays.asList(SqlStdOperatorTable.EQUALS.createCall(SqlImplementor.POS, start, SqlNumericLiteral.createExactNumeric("0", SqlImplementor.POS)));
            List<SqlNode> thenClauses = Arrays.asList(SqlNumericLiteral.createExactNumeric("1", SqlImplementor.POS));
            sqlCall.setOperand(1, SqlStdOperatorTable.CASE.createCall(null, SqlImplementor.POS, null, CalciteUtil.createSqlNodeList(whenClauses, SqlImplementor.POS), CalciteUtil.createSqlNodeList(thenClauses, SqlImplementor.POS), start));
        }
        return sqlCall;
    }
}

