/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.RelColumnOrigin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableBitSet;

public abstract class BuiltInMetadata {

    static interface All
    extends Selectivity,
    UniqueKeys,
    RowCount,
    DistinctRowCount,
    PercentageOriginalRows,
    ColumnUniqueness,
    ColumnOrigin,
    Predicates,
    Collation,
    Distribution,
    Size,
    Parallelism,
    Memory,
    AllPredicates,
    ExpressionLineage,
    TableReferences,
    NodeTypes {
    }

    public static interface Memory
    extends Metadata {
        public static final MetadataDef<Memory> DEF = MetadataDef.of(Memory.class, Handler.class, BuiltInMethod.MEMORY.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE.method, BuiltInMethod.CUMULATIVE_MEMORY_WITHIN_PHASE_SPLIT.method);

        public Double memory();

        public Double cumulativeMemoryWithinPhase();

        public Double cumulativeMemoryWithinPhaseSplit();

        public static interface Handler
        extends MetadataHandler<Memory> {
            public Double memory(RelNode var1, RelMetadataQuery var2);

            public Double cumulativeMemoryWithinPhase(RelNode var1, RelMetadataQuery var2);

            public Double cumulativeMemoryWithinPhaseSplit(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface Parallelism
    extends Metadata {
        public static final MetadataDef<Parallelism> DEF = MetadataDef.of(Parallelism.class, Handler.class, BuiltInMethod.IS_PHASE_TRANSITION.method, BuiltInMethod.SPLIT_COUNT.method);

        public Boolean isPhaseTransition();

        public Integer splitCount();

        public static interface Handler
        extends MetadataHandler<Parallelism> {
            public Boolean isPhaseTransition(RelNode var1, RelMetadataQuery var2);

            public Integer splitCount(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface AllPredicates
    extends Metadata {
        public static final MetadataDef<AllPredicates> DEF = MetadataDef.of(AllPredicates.class, Handler.class, BuiltInMethod.ALL_PREDICATES.method);

        public RelOptPredicateList getAllPredicates();

        public static interface Handler
        extends MetadataHandler<AllPredicates> {
            public RelOptPredicateList getAllPredicates(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface Predicates
    extends Metadata {
        public static final MetadataDef<Predicates> DEF = MetadataDef.of(Predicates.class, Handler.class, BuiltInMethod.PREDICATES.method);

        public RelOptPredicateList getPredicates();

        public static interface Handler
        extends MetadataHandler<Predicates> {
            public RelOptPredicateList getPredicates(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface ExplainVisibility
    extends Metadata {
        public static final MetadataDef<ExplainVisibility> DEF = MetadataDef.of(ExplainVisibility.class, Handler.class, BuiltInMethod.EXPLAIN_VISIBILITY.method);

        public Boolean isVisibleInExplain(SqlExplainLevel var1);

        public static interface Handler
        extends MetadataHandler<ExplainVisibility> {
            public Boolean isVisibleInExplain(RelNode var1, RelMetadataQuery var2, SqlExplainLevel var3);
        }
    }

    public static interface NonCumulativeCost
    extends Metadata {
        public static final MetadataDef<NonCumulativeCost> DEF = MetadataDef.of(NonCumulativeCost.class, Handler.class, BuiltInMethod.NON_CUMULATIVE_COST.method);

        public RelOptCost getNonCumulativeCost();

        public static interface Handler
        extends MetadataHandler<NonCumulativeCost> {
            public RelOptCost getNonCumulativeCost(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface CumulativeCost
    extends Metadata {
        public static final MetadataDef<CumulativeCost> DEF = MetadataDef.of(CumulativeCost.class, Handler.class, BuiltInMethod.CUMULATIVE_COST.method);

        public RelOptCost getCumulativeCost();

        public static interface Handler
        extends MetadataHandler<CumulativeCost> {
            public RelOptCost getCumulativeCost(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface TableReferences
    extends Metadata {
        public static final MetadataDef<TableReferences> DEF = MetadataDef.of(TableReferences.class, Handler.class, BuiltInMethod.TABLE_REFERENCES.method);

        public Set<RexTableInputRef.RelTableRef> getTableReferences();

        public static interface Handler
        extends MetadataHandler<TableReferences> {
            public Set<RexTableInputRef.RelTableRef> getTableReferences(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface ExpressionLineage
    extends Metadata {
        public static final MetadataDef<ExpressionLineage> DEF = MetadataDef.of(ExpressionLineage.class, Handler.class, BuiltInMethod.EXPRESSION_LINEAGE.method);

        public Set<RexNode> getExpressionLineage(RexNode var1);

        public static interface Handler
        extends MetadataHandler<ExpressionLineage> {
            public Set<RexNode> getExpressionLineage(RelNode var1, RelMetadataQuery var2, RexNode var3);
        }
    }

    public static interface ColumnOrigin
    extends Metadata {
        public static final MetadataDef<ColumnOrigin> DEF = MetadataDef.of(ColumnOrigin.class, Handler.class, BuiltInMethod.COLUMN_ORIGIN.method);

        public Set<RelColumnOrigin> getColumnOrigins(int var1);

        public static interface Handler
        extends MetadataHandler<ColumnOrigin> {
            public Set<RelColumnOrigin> getColumnOrigins(RelNode var1, RelMetadataQuery var2, int var3);
        }
    }

    public static interface Size
    extends Metadata {
        public static final MetadataDef<Size> DEF = MetadataDef.of(Size.class, Handler.class, BuiltInMethod.AVERAGE_ROW_SIZE.method, BuiltInMethod.AVERAGE_COLUMN_SIZES.method);

        public Double averageRowSize();

        public List<Double> averageColumnSizes();

        public static interface Handler
        extends MetadataHandler<Size> {
            public Double averageRowSize(RelNode var1, RelMetadataQuery var2);

            public List<Double> averageColumnSizes(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface PopulationSize
    extends Metadata {
        public static final MetadataDef<PopulationSize> DEF = MetadataDef.of(PopulationSize.class, Handler.class, BuiltInMethod.POPULATION_SIZE.method);

        public Double getPopulationSize(ImmutableBitSet var1);

        public static interface Handler
        extends MetadataHandler<PopulationSize> {
            public Double getPopulationSize(RelNode var1, RelMetadataQuery var2, ImmutableBitSet var3);
        }
    }

    public static interface PercentageOriginalRows
    extends Metadata {
        public static final MetadataDef<PercentageOriginalRows> DEF = MetadataDef.of(PercentageOriginalRows.class, Handler.class, BuiltInMethod.PERCENTAGE_ORIGINAL_ROWS.method);

        public Double getPercentageOriginalRows();

        public static interface Handler
        extends MetadataHandler<PercentageOriginalRows> {
            public Double getPercentageOriginalRows(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface DistinctRowCount
    extends Metadata {
        public static final MetadataDef<DistinctRowCount> DEF = MetadataDef.of(DistinctRowCount.class, Handler.class, BuiltInMethod.DISTINCT_ROW_COUNT.method);

        public Double getDistinctRowCount(ImmutableBitSet var1, RexNode var2);

        public static interface Handler
        extends MetadataHandler<DistinctRowCount> {
            public Double getDistinctRowCount(RelNode var1, RelMetadataQuery var2, ImmutableBitSet var3, RexNode var4);
        }
    }

    public static interface MinRowCount
    extends Metadata {
        public static final MetadataDef<MinRowCount> DEF = MetadataDef.of(MinRowCount.class, Handler.class, BuiltInMethod.MIN_ROW_COUNT.method);

        public Double getMinRowCount();

        public static interface Handler
        extends MetadataHandler<MinRowCount> {
            public Double getMinRowCount(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface MaxRowCount
    extends Metadata {
        public static final MetadataDef<MaxRowCount> DEF = MetadataDef.of(MaxRowCount.class, Handler.class, BuiltInMethod.MAX_ROW_COUNT.method);

        public Double getMaxRowCount();

        public static interface Handler
        extends MetadataHandler<MaxRowCount> {
            public Double getMaxRowCount(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface RowCount
    extends Metadata {
        public static final MetadataDef<RowCount> DEF = MetadataDef.of(RowCount.class, Handler.class, BuiltInMethod.ROW_COUNT.method);

        public Double getRowCount();

        public static interface Handler
        extends MetadataHandler<RowCount> {
            public Double getRowCount(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface NodeTypes
    extends Metadata {
        public static final MetadataDef<NodeTypes> DEF = MetadataDef.of(NodeTypes.class, Handler.class, BuiltInMethod.NODE_TYPES.method);

        public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes();

        public static interface Handler
        extends MetadataHandler<NodeTypes> {
            public Multimap<Class<? extends RelNode>, RelNode> getNodeTypes(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface Distribution
    extends Metadata {
        public static final MetadataDef<Distribution> DEF = MetadataDef.of(Distribution.class, Handler.class, BuiltInMethod.DISTRIBUTION.method);

        public RelDistribution distribution();

        public static interface Handler
        extends MetadataHandler<Distribution> {
            public RelDistribution distribution(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface Collation
    extends Metadata {
        public static final MetadataDef<Collation> DEF = MetadataDef.of(Collation.class, Handler.class, BuiltInMethod.COLLATIONS.method);

        public ImmutableList<RelCollation> collations();

        public static interface Handler
        extends MetadataHandler<Collation> {
            public ImmutableList<RelCollation> collations(RelNode var1, RelMetadataQuery var2);
        }
    }

    public static interface ColumnUniqueness
    extends Metadata {
        public static final MetadataDef<ColumnUniqueness> DEF = MetadataDef.of(ColumnUniqueness.class, Handler.class, BuiltInMethod.COLUMN_UNIQUENESS.method);

        public Boolean areColumnsUnique(ImmutableBitSet var1, boolean var2);

        public static interface Handler
        extends MetadataHandler<ColumnUniqueness> {
            public Boolean areColumnsUnique(RelNode var1, RelMetadataQuery var2, ImmutableBitSet var3, boolean var4);
        }
    }

    public static interface UniqueKeys
    extends Metadata {
        public static final MetadataDef<UniqueKeys> DEF = MetadataDef.of(UniqueKeys.class, Handler.class, BuiltInMethod.UNIQUE_KEYS.method);

        public Set<ImmutableBitSet> getUniqueKeys(boolean var1);

        public static interface Handler
        extends MetadataHandler<UniqueKeys> {
            public Set<ImmutableBitSet> getUniqueKeys(RelNode var1, RelMetadataQuery var2, boolean var3);
        }
    }

    public static interface Selectivity
    extends Metadata {
        public static final MetadataDef<Selectivity> DEF = MetadataDef.of(Selectivity.class, Handler.class, BuiltInMethod.SELECTIVITY.method);

        public Double getSelectivity(RexNode var1);

        public static interface Handler
        extends MetadataHandler<Selectivity> {
            public Double getSelectivity(RelNode var1, RelMetadataQuery var2, RexNode var3);
        }
    }
}

