/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.Version;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.CassandraTypeManager;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CassandraClusteringPredicatesExtractor {
    private final CassandraTypeManager cassandraTypeManager;
    private final ClusteringPushDownResult clusteringPushDownResult;
    private final TupleDomain<ColumnHandle> predicates;

    public CassandraClusteringPredicatesExtractor(CassandraTypeManager cassandraTypeManager, List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, Version cassandraVersion) {
        this.cassandraTypeManager = Objects.requireNonNull(cassandraTypeManager, "cassandraTypeManager is null");
        this.predicates = Objects.requireNonNull(predicates, "predicates is null");
        this.clusteringPushDownResult = this.getClusteringKeysSet(clusteringColumns, predicates, Objects.requireNonNull(cassandraVersion, "cassandraVersion is null"));
    }

    public String getClusteringKeyPredicates() {
        return this.clusteringPushDownResult.domainQuery();
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraints() {
        return this.predicates.filter((columnHandle, domain) -> !this.clusteringPushDownResult.hasBeenFullyPushed((ColumnHandle)columnHandle));
    }

    private ClusteringPushDownResult getClusteringKeysSet(List<CassandraColumnHandle> clusteringColumns, TupleDomain<ColumnHandle> predicates, Version cassandraVersion) {
        ImmutableSet.Builder fullyPushedColumnPredicates = ImmutableSet.builder();
        ImmutableList.Builder clusteringColumnSql = ImmutableList.builder();
        int allProcessedClusteringColumns = 0;
        for (CassandraColumnHandle columnHandle : clusteringColumns) {
            Domain domain = (Domain)((Map)predicates.getDomains().get()).get(columnHandle);
            if (domain == null || domain.isNullAllowed()) break;
            int currentlyProcessedClusteringColumn = allProcessedClusteringColumns++;
            String predicateString = (String)domain.getValues().getValuesProcessor().transform(ranges -> {
                if (ranges.getRangeCount() == 1) {
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return this.translateRangeIntoCql(columnHandle, (Range)Iterables.getOnlyElement((Iterable)ranges.getOrderedRanges()));
                }
                if (ranges.getOrderedRanges().stream().allMatch(Range::isSingleValue)) {
                    if (CassandraClusteringPredicatesExtractor.isInExpressionNotAllowed(clusteringColumns, cassandraVersion, currentlyProcessedClusteringColumn)) {
                        return this.translateRangeIntoCql(columnHandle, ranges.getSpan());
                    }
                    String inValues = ranges.getOrderedRanges().stream().map(range -> this.toCqlLiteral(columnHandle, range.getSingleValue())).collect(Collectors.joining(","));
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return CassandraCqlUtils.validColumnName(columnHandle.name()) + " IN (" + inValues + ")";
                }
                return this.translateRangeIntoCql(columnHandle, ranges.getSpan());
            }, discreteValues -> {
                if (discreteValues.isInclusive()) {
                    if (discreteValues.getValuesCount() == 0) {
                        return null;
                    }
                    if (discreteValues.getValuesCount() == 1) {
                        fullyPushedColumnPredicates.add((Object)columnHandle);
                        return String.format("%s = %s", CassandraCqlUtils.validColumnName(columnHandle.name()), this.toCqlLiteral(columnHandle, Iterables.getOnlyElement((Iterable)discreteValues.getValues())));
                    }
                    if (CassandraClusteringPredicatesExtractor.isInExpressionNotAllowed(clusteringColumns, cassandraVersion, currentlyProcessedClusteringColumn)) {
                        return null;
                    }
                    String inValues = discreteValues.getValues().stream().map(value -> this.cassandraTypeManager.toCqlLiteral(columnHandle.cassandraType(), value)).collect(Collectors.joining(","));
                    fullyPushedColumnPredicates.add((Object)columnHandle);
                    return CassandraCqlUtils.validColumnName(columnHandle.name()) + " IN (" + inValues + " )";
                }
                return null;
            }, allOrNone -> null);
            if (predicateString == null) break;
            clusteringColumnSql.add((Object)predicateString);
            if (predicateString.contains(">") || predicateString.contains("<")) break;
        }
        ImmutableList clusteringColumnPredicates = clusteringColumnSql.build();
        return new ClusteringPushDownResult((Set<ColumnHandle>)fullyPushedColumnPredicates.build(), Joiner.on((String)" AND ").join((Iterable)clusteringColumnPredicates));
    }

    private static boolean isInExpressionNotAllowed(List<CassandraColumnHandle> clusteringColumns, Version cassandraVersion, int currentlyProcessedClusteringColumn) {
        return cassandraVersion.compareTo(Version.parse((String)"2.2.0")) < 0 && currentlyProcessedClusteringColumn != clusteringColumns.size() - 1;
    }

    private String toCqlLiteral(CassandraColumnHandle columnHandle, Object value) {
        return this.cassandraTypeManager.toCqlLiteral(columnHandle.cassandraType(), value);
    }

    private String translateRangeIntoCql(CassandraColumnHandle columnHandle, Range range) {
        if (columnHandle.cassandraType().kind() == CassandraType.Kind.TUPLE || columnHandle.cassandraType().kind() == CassandraType.Kind.UDT) {
            return null;
        }
        if (range.isAll()) {
            return null;
        }
        if (range.isSingleValue()) {
            return String.format("%s = %s", CassandraCqlUtils.validColumnName(columnHandle.name()), this.toCqlLiteral(columnHandle, range.getSingleValue()));
        }
        String lowerBoundPredicate = null;
        String upperBoundPredicate = null;
        if (!range.isLowUnbounded()) {
            String lowBound = this.toCqlLiteral(columnHandle, range.getLowBoundedValue());
            lowerBoundPredicate = String.format("%s %s %s", CassandraCqlUtils.validColumnName(columnHandle.name()), range.isLowInclusive() ? ">=" : ">", lowBound);
        }
        if (!range.isHighUnbounded()) {
            String highBound = this.toCqlLiteral(columnHandle, range.getHighBoundedValue());
            upperBoundPredicate = String.format("%s %s %s", CassandraCqlUtils.validColumnName(columnHandle.name()), range.isHighInclusive() ? "<=" : "<", highBound);
        }
        if (lowerBoundPredicate != null && upperBoundPredicate != null) {
            return String.format("%s AND %s ", lowerBoundPredicate, upperBoundPredicate);
        }
        if (lowerBoundPredicate != null) {
            return lowerBoundPredicate;
        }
        return upperBoundPredicate;
    }

    private record ClusteringPushDownResult(Set<ColumnHandle> fullyPushedColumnPredicates, String domainQuery) {
        private ClusteringPushDownResult {
            fullyPushedColumnPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fullyPushedColumnPredicates, "fullyPushedColumnPredicates is null"));
            Objects.requireNonNull(domainQuery);
        }

        public boolean hasBeenFullyPushed(ColumnHandle column) {
            return this.fullyPushedColumnPredicates.contains(column);
        }
    }
}

