/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.cassandra.CassandraColumnHandle;
import io.trino.plugin.cassandra.CassandraNamedRelationHandle;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record CassandraTable(CassandraNamedRelationHandle tableHandle, List<CassandraColumnHandle> columns) {
    public CassandraTable {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    public List<CassandraColumnHandle> partitionKeyColumns() {
        return (List)this.columns.stream().filter(CassandraColumnHandle::partitionKey).collect(ImmutableList.toImmutableList());
    }

    public List<CassandraColumnHandle> clusteringKeyColumns() {
        return (List)this.columns.stream().filter(CassandraColumnHandle::clusteringKey).collect(ImmutableList.toImmutableList());
    }

    public String tokenExpression() {
        StringBuilder sb = new StringBuilder();
        for (CassandraColumnHandle column : this.partitionKeyColumns()) {
            if (sb.length() == 0) {
                sb.append("token(");
            } else {
                sb.append(",");
            }
            sb.append(CassandraCqlUtils.validColumnName(column.name()));
        }
        sb.append(")");
        return sb.toString();
    }
}

