/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public record CassandraType(Kind kind, Type trinoType, List<CassandraType> argumentTypes) {
    public CassandraType {
        Objects.requireNonNull(kind, "kind is null");
        Objects.requireNonNull(trinoType, "trinoType is null");
        argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public static CassandraType primitiveType(Kind kind, Type trinoType) {
        return new CassandraType(kind, trinoType, (List<CassandraType>)ImmutableList.of());
    }

    @Override
    public String toString() {
        Object result = String.format("%s(%s", new Object[]{this.kind, this.trinoType});
        if (!this.argumentTypes.isEmpty()) {
            result = (String)result + "; " + String.valueOf(this.argumentTypes);
        }
        result = (String)result + ")";
        return result;
    }

    public static enum Kind {
        BOOLEAN(true),
        TINYINT(true),
        SMALLINT(true),
        INT(true),
        BIGINT(true),
        FLOAT(true),
        DOUBLE(true),
        DECIMAL(true),
        DATE(true),
        TIME(true),
        TIMESTAMP(true),
        ASCII(true),
        TEXT(true),
        VARCHAR(true),
        BLOB(false),
        UUID(true),
        TIMEUUID(true),
        COUNTER(false),
        VARINT(false),
        INET(true),
        CUSTOM(false),
        LIST(false),
        SET(false),
        MAP(false),
        TUPLE(false),
        UDT(false);

        private final boolean supportedPartitionKey;

        private Kind(boolean supportedPartitionKey) {
            this.supportedPartitionKey = supportedPartitionKey;
        }

        public boolean isSupportedPartitionKey() {
            return this.supportedPartitionKey;
        }
    }
}

