/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import io.trino.plugin.cassandra.CassandraType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;

public final class CassandraTypes {
    public static final CassandraType ASCII = CassandraType.primitiveType(CassandraType.Kind.ASCII, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType BIGINT = CassandraType.primitiveType(CassandraType.Kind.BIGINT, (Type)BigintType.BIGINT);
    public static final CassandraType BLOB = CassandraType.primitiveType(CassandraType.Kind.BLOB, (Type)VarbinaryType.VARBINARY);
    public static final CassandraType BOOLEAN = CassandraType.primitiveType(CassandraType.Kind.BOOLEAN, (Type)BooleanType.BOOLEAN);
    public static final CassandraType COUNTER = CassandraType.primitiveType(CassandraType.Kind.COUNTER, (Type)BigintType.BIGINT);
    public static final CassandraType CUSTOM = CassandraType.primitiveType(CassandraType.Kind.CUSTOM, (Type)VarbinaryType.VARBINARY);
    public static final CassandraType DATE = CassandraType.primitiveType(CassandraType.Kind.DATE, (Type)DateType.DATE);
    public static final CassandraType DECIMAL = CassandraType.primitiveType(CassandraType.Kind.DECIMAL, (Type)DoubleType.DOUBLE);
    public static final CassandraType DOUBLE = CassandraType.primitiveType(CassandraType.Kind.DOUBLE, (Type)DoubleType.DOUBLE);
    public static final CassandraType FLOAT = CassandraType.primitiveType(CassandraType.Kind.FLOAT, (Type)RealType.REAL);
    public static final CassandraType INT = CassandraType.primitiveType(CassandraType.Kind.INT, (Type)IntegerType.INTEGER);
    public static final CassandraType LIST = CassandraType.primitiveType(CassandraType.Kind.LIST, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType MAP = CassandraType.primitiveType(CassandraType.Kind.MAP, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType SET = CassandraType.primitiveType(CassandraType.Kind.SET, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType SMALLINT = CassandraType.primitiveType(CassandraType.Kind.SMALLINT, (Type)SmallintType.SMALLINT);
    public static final CassandraType TEXT = CassandraType.primitiveType(CassandraType.Kind.TEXT, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType TIME = CassandraType.primitiveType(CassandraType.Kind.TIME, (Type)TimeType.TIME_NANOS);
    public static final CassandraType TIMESTAMP = CassandraType.primitiveType(CassandraType.Kind.TIMESTAMP, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    public static final CassandraType TIMEUUID = CassandraType.primitiveType(CassandraType.Kind.TIMEUUID, (Type)UuidType.UUID);
    public static final CassandraType TINYINT = CassandraType.primitiveType(CassandraType.Kind.TINYINT, (Type)TinyintType.TINYINT);
    public static final CassandraType UUID = CassandraType.primitiveType(CassandraType.Kind.UUID, (Type)UuidType.UUID);
    public static final CassandraType VARCHAR = CassandraType.primitiveType(CassandraType.Kind.VARCHAR, (Type)VarcharType.createUnboundedVarcharType());
    public static final CassandraType VARINT = CassandraType.primitiveType(CassandraType.Kind.VARINT, (Type)VarcharType.createUnboundedVarcharType());

    private CassandraTypes() {
    }
}

