/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.cassandra.CassandraSession;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;

public final class ExecuteProcedure
implements Provider<Procedure> {
    private static final MethodHandle EXECUTE;
    private final CassandraSession cassandraSession;

    @Inject
    public ExecuteProcedure(CassandraSession cassandraSession) {
        this.cassandraSession = Objects.requireNonNull(cassandraSession, "cassandraSession is null");
    }

    public Procedure get() {
        return new Procedure("system", "execute", (List)ImmutableList.of((Object)new Procedure.Argument("QUERY", (Type)VarcharType.VARCHAR)), EXECUTE.bindTo(this));
    }

    public void execute(String query) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.cassandraSession.execute(query);
        }
    }

    static {
        try {
            EXECUTE = MethodHandles.lookup().unreflect(ExecuteProcedure.class.getMethod("execute", String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

