/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import io.trino.plugin.cassandra.Murmur3PartitionerTokenRing;
import io.trino.plugin.cassandra.RandomPartitionerTokenRing;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public interface TokenRing {
    public double getRingFraction(Token var1, Token var2);

    public BigInteger getTokenCountInRange(Token var1, Token var2);

    public static Optional<TokenRing> createForPartitioner(String partitioner) {
        Objects.requireNonNull(partitioner, "partitioner is null");
        return switch (partitioner) {
            case "org.apache.cassandra.dht.Murmur3Partitioner" -> Optional.of(Murmur3PartitionerTokenRing.INSTANCE);
            case "org.apache.cassandra.dht.RandomPartitioner" -> Optional.of(RandomPartitionerTokenRing.INSTANCE);
            default -> Optional.empty();
        };
    }
}

