/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra.tls;

import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ssl.SslUtils;
import io.trino.plugin.cassandra.CassandraErrorCode;
import io.trino.plugin.cassandra.CassandraSessionConfigurator;
import io.trino.plugin.cassandra.tls.CassandraTlsConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.net.ssl.SSLContext;

public class CassandraTlsModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CassandraTlsConfig.class);
    }

    @ProvidesIntoSet
    @Singleton
    public CassandraSessionConfigurator tlsConfigurator(CassandraTlsConfig config) {
        return builder -> CassandraTlsModule.buildSslContext(config.getKeystorePath(), config.getKeystorePassword(), config.getTruststorePath(), config.getTruststorePassword()).ifPresent(arg_0 -> ((CqlSessionBuilder)builder).withSslContext(arg_0));
    }

    private static Optional<SSLContext> buildSslContext(Optional<File> keystorePath, Optional<String> keystorePassword, Optional<File> truststorePath, Optional<String> truststorePassword) {
        if (keystorePath.isEmpty() && truststorePath.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(SslUtils.createSSLContext(keystorePath, keystorePassword, truststorePath, truststorePassword));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new TrinoException((ErrorCodeSupplier)CassandraErrorCode.CASSANDRA_SSL_INITIALIZATION_FAILURE, (Throwable)e);
        }
    }
}

