/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToUInt32NodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.util.Set;

@ImportStatic(value={JSRuntime.class})
public abstract class JSToUInt32Node
extends JavaScriptBaseNode {
    private final boolean unsignedRightShift;
    private final int shiftValue;

    protected JSToUInt32Node(boolean unsignedRightShift, int shiftValue) {
        this.unsignedRightShift = unsignedRightShift;
        this.shiftValue = shiftValue;
    }

    @NeverDefault
    public static JSToUInt32Node create() {
        return JSToUInt32NodeGen.create(false, 0);
    }

    @NeverDefault
    public static JSToUInt32Node create(boolean unsignedRightShift, int shiftValue) {
        return JSToUInt32NodeGen.create(unsignedRightShift, shiftValue);
    }

    public abstract Object execute(Object var1);

    public final Number executeNumber(Object value) {
        return (Number)this.execute(value);
    }

    public final long executeLong(Object value) {
        return JSRuntime.longValue(this.executeNumber(value));
    }

    @Specialization(guards={"value >= 0"})
    protected int doInteger(int value) {
        return value;
    }

    @Specialization(guards={"value < 0"})
    protected SafeInteger doIntegerNegative(int value) {
        return SafeInteger.valueOf((long)value & 0xFFFFFFFFL);
    }

    @Specialization
    protected Object doSafeInteger(SafeInteger value) {
        long lValue = value.longValue() & 0xFFFFFFFFL;
        if (lValue > Integer.MAX_VALUE) {
            return SafeInteger.valueOf(lValue);
        }
        return (int)lValue;
    }

    @Specialization
    protected int doBoolean(boolean value) {
        return JSToUInt32Node.doBooleanStatic(value);
    }

    private static int doBooleanStatic(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization(guards={"isSafeInteger(value)"})
    protected static SafeInteger doLong(long value) {
        return SafeInteger.valueOf(value & 0xFFFFFFFFL);
    }

    @Specialization(guards={"!isSafeInteger(value)"})
    protected static SafeInteger doLongNotSafeInteger(long value) {
        return SafeInteger.valueOf((long)((double)value) & 0xFFFFFFFFL);
    }

    @Specialization(guards={"!isDoubleLargerThan2e32(value)"})
    protected double doDoubleFitsInt32Negative(double value) {
        return JSRuntime.toUInt32((long)value);
    }

    @Specialization(guards={"isDoubleLargerThan2e32(value)", "isDoubleRepresentableAsLong(value)"})
    protected double doDoubleRepresentableAsLong(double value) {
        return JSRuntime.toUInt32NoTruncate(value);
    }

    @Specialization(guards={"isDoubleLargerThan2e32(value)", "!isDoubleRepresentableAsLong(value)"})
    protected double doDouble(double value) {
        return JSRuntime.toUInt32(value);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected int doNull(Object value) {
        return 0;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected int doUndefined(Object value) {
        return 0;
    }

    @Specialization
    protected double doString(TruffleString value, @Cached JSStringToNumberNode stringToNumberNode) {
        return JSRuntime.toUInt32(stringToNumberNode.execute(value));
    }

    private static double doStringStatic(TruffleString value) {
        return JSRuntime.toUInt32(JSRuntime.doubleValue(JSRuntime.stringToNumber(value)));
    }

    @Specialization
    protected final Number doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected int doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertBigIntToNumber(this);
    }

    @Idempotent
    protected final boolean isUnsignedRightShift() {
        return this.unsignedRightShift;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isUnsignedRightShift()"})
    protected Object doOverloadedOperator(JSOverloadedOperatorsObject value, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(value, this.shiftValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_CLOSE_3;
    }

    @Specialization(guards={"!isUnsignedRightShift() || !hasOverloadedOperators(value)"})
    protected double doJSObject(JSObject value, @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toUInt32(toNumberNode.executeNumber((Object)value));
    }

    @Specialization(guards={"isForeignObject(object)"})
    protected static double doForeignObject(Object object, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached JSToUInt32Node toUInt32Node) {
        return JSRuntime.toDouble(toUInt32Node.executeNumber(toPrimitiveNode.execute(object)));
    }

    public static abstract class JSToUInt32WrapperNode
    extends JSUnaryNode {
        protected final boolean unsignedRightShift;
        protected final int shiftValue;

        protected JSToUInt32WrapperNode(JavaScriptNode operand, boolean unsignedRightShift, int shiftValue) {
            super(operand);
            this.unsignedRightShift = unsignedRightShift;
            this.shiftValue = shiftValue;
        }

        public static JavaScriptNode create(JavaScriptNode child) {
            return JSToUInt32WrapperNode.create(child, false, 0);
        }

        public static JavaScriptNode create(JavaScriptNode child, boolean unsignedRightShift, int shiftValue) {
            if (child instanceof JSConstantNode.JSConstantIntegerNode) {
                int value = ((JSConstantNode.JSConstantIntegerNode)child).executeInt(null);
                long unsignedValue = Integer.toUnsignedLong(value);
                if (unsignedValue == (long)value) {
                    return child;
                }
                return JSConstantNode.createDouble(unsignedValue);
            }
            if (child instanceof JSConstantNode.JSConstantDoubleNode) {
                double value = ((JSConstantNode.JSConstantDoubleNode)child).executeDouble(null);
                return JSConstantNode.createDouble(JSRuntime.toUInt32(value));
            }
            if (child instanceof JSConstantNode.JSConstantBooleanNode) {
                boolean value = ((JSConstantNode.JSConstantBooleanNode)child).executeBoolean(null);
                return JSConstantNode.createInt(JSToUInt32Node.doBooleanStatic(value));
            }
            if (child instanceof JSConstantNode.JSConstantUndefinedNode || child instanceof JSConstantNode.JSConstantNullNode) {
                return JSConstantNode.createInt(0);
            }
            if (child instanceof JSConstantNode.JSConstantStringNode) {
                Object value = child.execute(null);
                return JSConstantNode.createDouble(JSToUInt32Node.doStringStatic((TruffleString)value));
            }
            if (child instanceof JSToInt32Node.JSToInt32UnaryNode) {
                JSToInt32Node.JSToInt32UnaryNode toInt32Child = (JSToInt32Node.JSToInt32UnaryNode)child;
                if (toInt32Child.isBitwiseOr() && unsignedRightShift) {
                    return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(toInt32Child, unsignedRightShift, shiftValue);
                }
                return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(toInt32Child.getOperand());
            }
            return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(child, unsignedRightShift, shiftValue);
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached(value="create(unsignedRightShift, shiftValue)") JSToUInt32Node toUInt32Node) {
            return toUInt32Node.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToUInt32NodeGen.JSToUInt32WrapperNodeGen.create(JSToUInt32WrapperNode.cloneUninitialized(this.getOperand(), materializedTags), this.unsignedRightShift, this.shiftValue);
        }
    }
}

