/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOrBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeNumberFormatNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.nodes.intl.SetNumberFormatDigitOptionsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.List;
import java.util.MissingResourceException;

public abstract class InitializeNumberFormatNode
extends JavaScriptBaseNode {
    private static final List<String> CURRENCY_SIGN_OPTION_VALUES = List.of("standard", "accounting");
    private static final List<String> STYLE_OPTION_VALUES = List.of("decimal", "percent", "currency", "unit");
    private static final List<String> CURRENCY_DISPLAY_OPTION_VALUES = List.of("code", "symbol", "narrowSymbol", "name");
    private static final List<String> NOTATION_OPTION_VALUES = List.of("standard", "scientific", "engineering", "compact");
    private static final List<String> COMPACT_OPTION_VALUES = List.of("short", "long");
    private static final List<String> USE_GROUPING_OPTION_VALUES = List.of("min2", "auto", "always");
    private static final List<String> SIGN_DISPLAY_OPTION_VALUES = List.of("auto", "never", "always", "exceptZero", "negative");
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getNumberingSystemOption;
    @Node.Child
    SetNumberFormatDigitOptionsNode setNumberFormatDigitOptions;
    @Node.Child
    GetStringOptionNode getStyleOption;
    @Node.Child
    GetStringOptionNode getCurrencyOption;
    @Node.Child
    GetStringOptionNode getCurrencyDisplayOption;
    @Node.Child
    GetStringOptionNode getCurrencySignOption;
    @Node.Child
    GetStringOptionNode getUnitOption;
    @Node.Child
    GetStringOptionNode getUnitDisplayOption;
    @Node.Child
    GetStringOptionNode getNotationOption;
    @Node.Child
    GetStringOptionNode getCompactDisplayOption;
    @Node.Child
    GetStringOrBooleanOptionNode getUseGroupingOption;
    @Node.Child
    GetStringOptionNode getSignDisplayOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeNumberFormatNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, IntlUtil.KEY_LOCALE_MATCHER, GetStringOptionNode.LOCALE_MATCHER_OPTION_VALUES, "best fit");
        this.getNumberingSystemOption = GetStringOptionNode.create(context, IntlUtil.KEY_NUMBERING_SYSTEM, null, null);
        this.getStyleOption = GetStringOptionNode.create(context, IntlUtil.KEY_STYLE, STYLE_OPTION_VALUES, "decimal");
        this.getCurrencyOption = GetStringOptionNode.create(context, IntlUtil.KEY_CURRENCY, null, null);
        this.getCurrencyDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_CURRENCY_DISPLAY, CURRENCY_DISPLAY_OPTION_VALUES, "symbol");
        this.getCurrencySignOption = GetStringOptionNode.create(context, IntlUtil.KEY_CURRENCY_SIGN, CURRENCY_SIGN_OPTION_VALUES, "standard");
        this.getUnitOption = GetStringOptionNode.create(context, IntlUtil.KEY_UNIT, null, null);
        this.getUnitDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_UNIT_DISPLAY, GetStringOptionNode.LONG_SHORT_NARROW_OPTION_VALUES, "short");
        this.getNotationOption = GetStringOptionNode.create(context, IntlUtil.KEY_NOTATION, NOTATION_OPTION_VALUES, "standard");
        this.getCompactDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_COMPACT_DISPLAY, COMPACT_OPTION_VALUES, "short");
        this.getUseGroupingOption = GetStringOrBooleanOptionNode.create(context, IntlUtil.KEY_USE_GROUPING, USE_GROUPING_OPTION_VALUES, "always", false, null);
        this.getSignDisplayOption = GetStringOptionNode.create(context, IntlUtil.KEY_SIGN_DISPLAY, SIGN_DISPLAY_OPTION_VALUES, "auto");
        this.setNumberFormatDigitOptions = SetNumberFormatDigitOptionsNode.create(context);
    }

    public abstract JSNumberFormatObject executeInit(JSNumberFormatObject var1, Object var2, Object var3);

    public static InitializeNumberFormatNode createInitalizeNumberFormatNode(JSContext context) {
        return InitializeNumberFormatNodeGen.create(context);
    }

    @Specialization
    public JSNumberFormatObject initializeNumberFormat(JSNumberFormatObject numberFormatObj, Object localesArg, Object optionsArg) {
        try {
            Object useGrouping;
            int mxfdDefault;
            int mnfdDefault;
            JSNumberFormat.InternalState state = numberFormatObj.getInternalState();
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String numberingSystem = this.getNumberingSystemOption.executeValue(options);
            if (numberingSystem != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(numberingSystem, this.errorBranch);
                numberingSystem = IntlUtil.normalizeUnicodeLocaleIdentifierType(numberingSystem);
            }
            state.resolveLocaleAndNumberingSystem(this.context, locales, numberingSystem);
            this.setNumberFormatUnitOptions(state, options);
            String style = state.getStyle();
            if ("currency".equals(style)) {
                int cDigits;
                mnfdDefault = cDigits = JSNumberFormat.currencyDigits(this.context, state.getCurrency());
                mxfdDefault = cDigits;
            } else {
                mnfdDefault = 0;
                mxfdDefault = "percent".equals(style) ? 0 : 3;
            }
            String notation = this.getNotationOption.executeValue(options);
            state.setNotation(notation);
            boolean compactNotation = "compact".equals(notation);
            this.setNumberFormatDigitOptions.execute(state, options, mnfdDefault, mxfdDefault, compactNotation);
            String compactDisplay = this.getCompactDisplayOption.executeValue(options);
            String defaultUseGrouping = "auto";
            if (compactNotation) {
                state.setCompactDisplay(compactDisplay);
                defaultUseGrouping = "min2";
            }
            if ((useGrouping = this.getUseGroupingOption.executeValue(options)) == null) {
                useGrouping = defaultUseGrouping;
            }
            state.setGroupingUsed(useGrouping);
            String signDisplay = this.getSignDisplayOption.executeValue(options);
            state.setSignDisplay(signDisplay);
            state.initializeNumberFormatter();
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return numberFormatObj;
    }

    private void setNumberFormatUnitOptions(JSNumberFormat.InternalState state, Object options) {
        String style = this.getStyleOption.executeValue(options);
        state.setStyle(style);
        boolean styleIsCurrency = "currency".equals(style);
        boolean styleIsUnit = "unit".equals(style);
        String currency = this.getCurrencyOption.executeValue(options);
        if (currency == null) {
            if (styleIsCurrency) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Currency can not be undefined when style is \"currency\".");
            }
        } else {
            IntlUtil.ensureIsWellFormedCurrencyCode(currency);
        }
        String currencyDisplay = this.getCurrencyDisplayOption.executeValue(options);
        String currencySign = this.getCurrencySignOption.executeValue(options);
        String unit = this.getUnitOption.executeValue(options);
        if (unit == null) {
            if (styleIsUnit) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Unit can not be undefined when style is \"unit\".");
            }
        } else {
            IntlUtil.ensureIsWellFormedUnitIdentifier(unit);
        }
        String unitDisplay = this.getUnitDisplayOption.executeValue(options);
        if (styleIsCurrency) {
            currency = IntlUtil.toUpperCase(currency);
            state.setCurrency(currency);
            state.setCurrencyDisplay(currencyDisplay);
            state.setCurrencySign(currencySign);
        } else if (styleIsUnit) {
            state.setUnit(unit);
            state.setUnitDisplay(unitDisplay);
        }
    }
}

