/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateTimeNode;
import com.oracle.truffle.js.nodes.temporal.TemporalDifferenceDateNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.NormalizedDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalDurationWithTotalRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.math.BigDecimal;
import java.math.MathContext;

public abstract class RoundRelativeDurationNode
extends JavaScriptBaseNode {
    protected RoundRelativeDurationNode() {
    }

    public abstract TemporalDurationWithTotalRecord execute(NormalizedDurationRecord var1, BigInt var2, ISODateTimeRecord var3, CalendarMethodsRecord var4, TimeZoneMethodsRecord var5, TemporalUtil.Unit var6, int var7, TemporalUtil.Unit var8, TemporalUtil.RoundingMode var9);

    @Specialization
    protected final TemporalDurationWithTotalRecord roundRelativeDuration(NormalizedDurationRecord duration0, BigInt destEpochNs, ISODateTimeRecord dateTime, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, TemporalUtil.Unit largestUnit0, int increment, TemporalUtil.Unit smallestUnit, TemporalUtil.RoundingMode roundingMode, @Cached TemporalAddDateTimeNode addDateTimeNode, @Cached TemporalDifferenceDateNode differenceDateNode, @Cached InlinedBranchProfile errorBranch) {
        int sign;
        NormalizedDurationRecord duration = duration0;
        TemporalUtil.Unit largestUnit = largestUnit0;
        boolean irregularLengthUnit = smallestUnit.isCalendarUnit();
        if (timeZoneRec != null && smallestUnit == TemporalUtil.Unit.DAY) {
            irregularLengthUnit = true;
        }
        int n = sign = TemporalUtil.durationSign(duration.years(), duration.months(), duration.weeks(), duration.days(), TemporalUtil.normalizedTimeDurationSign(duration.normalizedTimeTotalNanoseconds()), 0.0, 0.0, 0.0, 0.0, 0.0) < 0 ? -1 : 1;
        DurationNudgeResultRecord nudgeResult = irregularLengthUnit ? this.nudgeToCalendarUnit(sign, duration, destEpochNs, dateTime, calendarRec, timeZoneRec, increment, smallestUnit, roundingMode, addDateTimeNode, differenceDateNode, errorBranch) : (timeZoneRec != null ? this.nudgeToZonedTime(sign, duration, dateTime, calendarRec, timeZoneRec, increment, smallestUnit, roundingMode, addDateTimeNode, errorBranch) : RoundRelativeDurationNode.nudgeToDayOrTime(duration, destEpochNs, largestUnit, increment, smallestUnit, roundingMode));
        duration = nudgeResult.duration();
        if (nudgeResult.didExpandCalendarUnit() && smallestUnit != TemporalUtil.Unit.WEEK) {
            TemporalUtil.Unit startUnit = TemporalUtil.largerOfTwoTemporalUnits(smallestUnit, TemporalUtil.Unit.DAY);
            duration = this.bubbleRelativeDuration(sign, duration, nudgeResult.nudgedEpochNs(), dateTime, calendarRec, timeZoneRec, largestUnit, startUnit, addDateTimeNode, errorBranch);
        }
        if (largestUnit.isCalendarUnit() || largestUnit == TemporalUtil.Unit.DAY) {
            largestUnit = TemporalUtil.Unit.HOUR;
        }
        TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(duration.normalizedTimeTotalNanoseconds(), largestUnit);
        return new TemporalDurationWithTotalRecord(JSTemporalDurationRecord.createWeeks(duration.years(), duration.months(), duration.weeks(), duration.days(), balanceResult.hours(), balanceResult.minutes(), balanceResult.seconds(), balanceResult.milliseconds(), balanceResult.microseconds(), balanceResult.nanoseconds()), nudgeResult.total());
    }

    private DurationNudgeResultRecord nudgeToCalendarUnit(int sign, NormalizedDurationRecord duration, BigInt destEpochNs, ISODateTimeRecord dateTime, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, TemporalAddDateTimeNode addDateTimeNode, TemporalDifferenceDateNode differenceDateNode, InlinedBranchProfile errorBranch) {
        BigInt nudgedEpochNs;
        NormalizedDurationRecord resultDuration;
        boolean didExpandCalendarUnit;
        BigInt endEpochNs;
        BigInt startEpochNs;
        NormalizedDurationRecord startDuration;
        double r2;
        double r1;
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        NormalizedDurationRecord endDuration = switch (unit) {
            case TemporalUtil.Unit.YEAR -> {
                double years;
                r1 = years = TemporalUtil.roundNumberToIncrement(duration.years(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = years + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(r1, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(r2, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.MONTH -> {
                double months;
                r1 = months = TemporalUtil.roundNumberToIncrement(duration.months(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = months + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), r1, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), r2, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.WEEK -> {
                double weeks;
                ISODateRecord isoResult1 = TemporalUtil.balanceISODate((double)dateTime.year() + duration.years(), (double)dateTime.month() + duration.months(), (double)dateTime.day());
                ISODateRecord isoResult2 = TemporalUtil.balanceISODate((double)dateTime.year() + duration.years(), (double)dateTime.month() + duration.months(), (double)dateTime.day() + duration.days());
                JSTemporalPlainDateObject weeksStart = JSTemporalPlainDate.create(ctx, realm, isoResult1.year(), isoResult1.month(), isoResult1.day(), calendarRec.receiver(), this, errorBranch);
                JSTemporalPlainDateObject weeksEnd = JSTemporalPlainDate.create(ctx, realm, isoResult2.year(), isoResult2.month(), isoResult2.day(), calendarRec.receiver(), this, errorBranch);
                JSObject untilOptions = JSOrdinary.createWithNullPrototype(ctx);
                JSObjectUtil.putDataProperty(untilOptions, TemporalConstants.LARGEST_UNIT, TemporalConstants.WEEK);
                JSTemporalDurationObject untilResult = differenceDateNode.execute(calendarRec, weeksStart, weeksEnd, TemporalUtil.Unit.WEEK, untilOptions);
                r1 = weeks = TemporalUtil.roundNumberToIncrement(duration.weeks() + untilResult.getWeeks(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = weeks + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), r1, 0.0, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), r2, 0.0, TemporalUtil.zeroTimeDuration());
            }
            case TemporalUtil.Unit.DAY -> {
                double days;
                r1 = days = TemporalUtil.roundNumberToIncrement(duration.days(), increment, TemporalUtil.RoundingMode.TRUNC);
                r2 = days + (double)(increment * sign);
                startDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), r1, TemporalUtil.zeroTimeDuration());
                yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), r2, TemporalUtil.zeroTimeDuration());
            }
            default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unit);
        };
        JSTemporalDateTimeRecord start = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendarRec, startDuration.years(), startDuration.months(), startDuration.weeks(), startDuration.days(), startDuration.normalizedTimeTotalNanoseconds(), Undefined.instance);
        JSTemporalDateTimeRecord end = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendarRec, endDuration.years(), endDuration.months(), endDuration.weeks(), endDuration.days(), endDuration.normalizedTimeTotalNanoseconds(), Undefined.instance);
        if (timeZoneRec == null) {
            startEpochNs = TemporalUtil.getUTCEpochNanoseconds(start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond());
            endEpochNs = TemporalUtil.getUTCEpochNanoseconds(end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond());
        } else {
            JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(ctx, realm, start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendarRec.receiver(), this, errorBranch);
            JSTemporalInstantObject startInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            startEpochNs = startInstant.getNanoseconds();
            JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond(), calendarRec.receiver(), this, errorBranch);
            JSTemporalInstantObject endInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            endEpochNs = endInstant.getNanoseconds();
        }
        if (startEpochNs.compareTo(endEpochNs) == 0) {
            throw Errors.createRangeError("custom calendar method returned an illegal result");
        }
        boolean isNegative = sign < 0;
        TemporalUtil.UnsignedRoundingMode unsignedRoundingMode = TemporalUtil.getUnsignedRoundingMode(roundingMode, isNegative);
        BigInt numerator = destEpochNs.subtract(startEpochNs);
        BigInt denominator = endEpochNs.subtract(startEpochNs);
        double total = RoundRelativeDurationNode.computeTotal(r1, increment, sign, numerator, denominator);
        double roundedUnit = TemporalUtil.applyUnsignedRoundingMode(numerator, denominator, r1, r2, unsignedRoundingMode);
        int roundedSign = Double.compare(roundedUnit - total, 0.0);
        if (roundedSign == sign) {
            didExpandCalendarUnit = true;
            resultDuration = endDuration;
            nudgedEpochNs = endEpochNs;
        } else {
            didExpandCalendarUnit = false;
            resultDuration = startDuration;
            nudgedEpochNs = startEpochNs;
        }
        return new DurationNudgeResultRecord(resultDuration, total, nudgedEpochNs, didExpandCalendarUnit);
    }

    @CompilerDirectives.TruffleBoundary
    private static double computeTotal(double r1, int increment, int sign, BigInt numerator, BigInt denominator) {
        BigDecimal progress = new BigDecimal(numerator.bigIntegerValue()).divide(new BigDecimal(denominator.bigIntegerValue()), MathContext.DECIMAL128);
        BigDecimal total = new BigDecimal(r1).add(progress.multiply(new BigDecimal(increment * sign)));
        return total.doubleValue();
    }

    private DurationNudgeResultRecord nudgeToZonedTime(int sign, NormalizedDurationRecord duration, ISODateTimeRecord dateTime, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode, TemporalAddDateTimeNode addDateTimeNode, InlinedBranchProfile errorBranch) {
        BigInt nudgedEpochNs;
        int dayDelta;
        boolean didRoundBeyondDay;
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        JSTemporalDateTimeRecord start = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendarRec, duration.years(), duration.months(), duration.weeks(), duration.days(), TemporalUtil.zeroTimeDuration(), Undefined.instance);
        JSTemporalPlainDateTimeObject startDateTime = JSTemporalPlainDateTime.create(ctx, realm, start.getYear(), start.getMonth(), start.getDay(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendarRec.receiver(), this, errorBranch);
        ISODateRecord endDate = TemporalUtil.balanceISODate(start.getYear(), start.getMonth(), start.getDay() + sign);
        JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, endDate.year(), endDate.month(), endDate.day(), start.getHour(), start.getMinute(), start.getSecond(), start.getMillisecond(), start.getMicrosecond(), start.getNanosecond(), calendarRec.receiver(), this, errorBranch);
        JSTemporalInstantObject startInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, startDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        BigInt startEpochNs = startInstant.getNanoseconds();
        JSTemporalInstantObject endInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
        BigInt endEpochNs = endInstant.getNanoseconds();
        BigInt daySpan = TemporalUtil.normalizedTimeDurationFromEpochNanosecondsDifference(endEpochNs, startEpochNs);
        assert (TemporalUtil.normalizedTimeDurationSign(daySpan) == sign);
        long unitLength = unit.getLengthInNanoseconds();
        BigInt roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(duration.normalizedTimeTotalNanoseconds(), unitLength, increment, roundingMode);
        BigInt beyondDaySpan = TemporalUtil.subtractNormalizedTimeDuration(roundedNorm, daySpan);
        if (TemporalUtil.normalizedTimeDurationSign(beyondDaySpan) != -sign) {
            didRoundBeyondDay = true;
            dayDelta = sign;
            roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(beyondDaySpan, unitLength, increment, roundingMode);
            nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(roundedNorm, endEpochNs);
        } else {
            didRoundBeyondDay = false;
            dayDelta = 0;
            nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(roundedNorm, startEpochNs);
        }
        NormalizedDurationRecord resultDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), duration.days() + (double)dayDelta, roundedNorm);
        return new DurationNudgeResultRecord(resultDuration, Double.NaN, nudgedEpochNs, didRoundBeyondDay);
    }

    private static DurationNudgeResultRecord nudgeToDayOrTime(NormalizedDurationRecord duration, BigInt destEpochNs, TemporalUtil.Unit largestUnit, int increment, TemporalUtil.Unit unit, TemporalUtil.RoundingMode roundingMode) {
        BigInt norm = TemporalUtil.add24HourDaysToNormalizedTimeDuration(duration.normalizedTimeTotalNanoseconds(), duration.days());
        long unitLength = unit.getLengthInNanoseconds();
        double total = TemporalUtil.divideNormalizedTimeDurationAsDouble(norm, unitLength);
        BigInt roundedNorm = TemporalUtil.roundNormalizedTimeDurationToIncrement(norm, unitLength, increment, roundingMode);
        BigInt diffNorm = TemporalUtil.subtractNormalizedTimeDuration(roundedNorm, norm);
        double wholeDays = TemporalUtil.divideNormalizedTimeDurationAsDoubleTruncate(norm, 86400000000000L);
        double roundedWholeDays = TemporalUtil.divideNormalizedTimeDurationAsDoubleTruncate(roundedNorm, 86400000000000L);
        double dayDelta = roundedWholeDays - wholeDays;
        int dayDeltaSign = Double.compare(dayDelta, 0.0);
        boolean didExpandDays = dayDeltaSign == TemporalUtil.normalizedTimeDurationSign(norm);
        BigInt nudgedEpochNs = TemporalUtil.addNormalizedTimeDurationToEpochNanoseconds(diffNorm, destEpochNs);
        double days = 0.0;
        BigInt remainder = roundedNorm;
        if (TemporalUtil.largerOfTwoTemporalUnits(largestUnit, TemporalUtil.Unit.DAY) == largestUnit) {
            days = roundedWholeDays;
            remainder = TemporalUtil.remainderNormalizedTimeDuration(roundedNorm, 86400000000000L);
        }
        NormalizedDurationRecord resultDuration = TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), days, remainder);
        return new DurationNudgeResultRecord(resultDuration, total, nudgedEpochNs, didExpandDays);
    }

    private NormalizedDurationRecord bubbleRelativeDuration(int sign, NormalizedDurationRecord duration0, BigInt nudgedEpochNs, ISODateTimeRecord dateTime, CalendarMethodsRecord calendarRec, TimeZoneMethodsRecord timeZoneRec, TemporalUtil.Unit largestUnit, TemporalUtil.Unit smallestUnit, TemporalAddDateTimeNode addDateTimeNode, InlinedBranchProfile errorBranch) {
        assert (largestUnit.isDateUnit()) : largestUnit;
        assert (smallestUnit.isDateUnit()) : smallestUnit;
        NormalizedDurationRecord duration = duration0;
        if (smallestUnit == TemporalUtil.Unit.YEAR) {
            return duration;
        }
        JSRealm realm = this.getRealm();
        JSContext ctx = this.getJSContext();
        int largestUnitIndex = largestUnit.ordinal();
        int smallestUnitIndex = smallestUnit.ordinal();
        for (int unitIndex = smallestUnitIndex - 1; unitIndex >= largestUnitIndex; --unitIndex) {
            BigInt endEpochNs;
            TemporalUtil.Unit unit = TemporalUtil.Unit.VALUES[unitIndex];
            if (unit == TemporalUtil.Unit.WEEK && largestUnit != TemporalUtil.Unit.WEEK) continue;
            NormalizedDurationRecord endDuration = switch (unit) {
                case TemporalUtil.Unit.YEAR -> {
                    double years = duration.years() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(years, 0.0, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.MONTH -> {
                    double months = duration.months() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), months, 0.0, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.WEEK -> {
                    double weeks = duration.weeks() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), weeks, 0.0, TemporalUtil.zeroTimeDuration());
                }
                case TemporalUtil.Unit.DAY -> {
                    double days = duration.days() + (double)sign;
                    yield TemporalUtil.createNormalizedDurationRecord(duration.years(), duration.months(), duration.weeks(), days, TemporalUtil.zeroTimeDuration());
                }
                default -> throw Errors.shouldNotReachHereUnexpectedValue((Object)unit);
            };
            JSTemporalDateTimeRecord end = addDateTimeNode.execute(dateTime.year(), dateTime.month(), dateTime.day(), dateTime.hour(), dateTime.minute(), dateTime.second(), dateTime.millisecond(), dateTime.microsecond(), dateTime.nanosecond(), calendarRec, endDuration.years(), endDuration.months(), endDuration.weeks(), endDuration.days(), endDuration.normalizedTimeTotalNanoseconds(), Undefined.instance);
            if (timeZoneRec == null) {
                endEpochNs = TemporalUtil.getUTCEpochNanoseconds(end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond());
            } else {
                JSTemporalPlainDateTimeObject endDateTime = JSTemporalPlainDateTime.create(ctx, realm, end.getYear(), end.getMonth(), end.getDay(), end.getHour(), end.getMinute(), end.getSecond(), end.getMillisecond(), end.getMicrosecond(), end.getNanosecond(), calendarRec.receiver(), this, errorBranch);
                JSTemporalInstantObject endInstant = TemporalUtil.builtinTimeZoneGetInstantFor(ctx, realm, timeZoneRec, endDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
                endEpochNs = endInstant.getNanoseconds();
            }
            BigInt beyondEnd = nudgedEpochNs.subtract(endEpochNs);
            int beyondEndSign = beyondEnd.signum();
            if (beyondEndSign == -sign) break;
            duration = endDuration;
        }
        return duration;
    }

    public record DurationNudgeResultRecord(NormalizedDurationRecord duration, double total, BigInt nudgedEpochNs, boolean didExpandCalendarUnit) {
    }
}

