/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={JSWebAssemblyValueTypes.class})
@GenerateUncached
public abstract class ToWebAssemblyValueNode
extends JavaScriptBaseNode {
    protected ToWebAssemblyValueNode() {
    }

    public abstract Object execute(Object var1, TruffleString var2);

    @Specialization(guards={"isI32(type)"})
    static int i32(Object value, TruffleString type, @Cached JSToInt32Node toInt32Node) {
        return toInt32Node.executeInt(value);
    }

    @Specialization(guards={"isI64(type)"})
    static long i64(Object value, TruffleString type, @Cached JSToBigIntNode toBigIntNode) {
        return toBigIntNode.executeBigInteger(value).longValue();
    }

    @Specialization(guards={"isF32(type)"})
    static float f32(Object value, TruffleString type, @Cached @Cached.Shared JSToNumberNode toNumberNode) {
        Number numberValue = toNumberNode.executeNumber(value);
        double doubleValue = JSRuntime.toDouble(numberValue);
        return (float)doubleValue;
    }

    @Specialization(guards={"isF64(type)"})
    static double f64(Object value, TruffleString type, @Cached @Cached.Shared JSToNumberNode toNumberNode) {
        Number numberValue = toNumberNode.executeNumber(value);
        return JSRuntime.toDouble(numberValue);
    }

    @Specialization(guards={"isAnyfunc(type)"})
    final Object anyfunc(Object value, TruffleString type, @Cached InlinedBranchProfile errorBranch) {
        if (value == Null.instance) {
            return this.getRealm().getWasmRefNull();
        }
        if (JSWebAssembly.isExportedFunction(value)) {
            return JSWebAssembly.getExportedFunction((JSDynamicObject)((Object)value));
        }
        errorBranch.enter((Node)this);
        throw ToWebAssemblyValueNode.notAnExportedFunctionError();
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException notAnExportedFunctionError() {
        throw Errors.createTypeError("value is not an exported function");
    }

    @Specialization(guards={"isExternref(type)"})
    final Object externref(Object value, TruffleString type) {
        if (value == Null.instance) {
            return this.getRealm().getWasmRefNull();
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    final Object fallback(Object value, TruffleString type) {
        throw Errors.createTypeError("Unknown type: " + String.valueOf(type), (Node)this);
    }
}

