/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.Preconditions;
import java.util.Objects;

public final class NodeLocation {
    private final int line;
    private final int column;

    public NodeLocation(int line, int column) {
        Preconditions.checkArgument(line >= 1, "line must be at least one, got: %s", line);
        Preconditions.checkArgument(column >= 1, "column must be at least one, got: %s", column);
        this.line = line;
        this.column = column;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public String toString() {
        return this.line + ":" + this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeLocation that = (NodeLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

