/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Relation;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Union
extends SetOperation {
    private final List<Relation> relations;

    public Union(List<Relation> relations, boolean distinct) {
        this(Optional.empty(), relations, distinct);
    }

    public Union(NodeLocation location, List<Relation> relations, boolean distinct) {
        this(Optional.of(location), relations, distinct);
    }

    private Union(Optional<NodeLocation> location, List<Relation> relations, boolean distinct) {
        super(location, distinct);
        Objects.requireNonNull(relations, "relations is null");
        this.relations = ImmutableList.copyOf(relations);
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnion(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.relations;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("relations", this.relations).add("distinct", this.isDistinct()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Union o = (Union)obj;
        return Objects.equals(this.relations, o.relations) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relations, this.isDistinct());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Union.sameClass(this, other)) {
            return false;
        }
        return this.isDistinct() == ((Union)other).isDistinct();
    }
}

