/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.thrift;

import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.FetchFormatter;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.SerDeUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class ThriftFormatter
implements FetchFormatter<Object> {
    int protocol;

    @Override
    public void initialize(Configuration hconf, Properties props) throws Exception {
        this.protocol = hconf.getInt("list.sink.output.protocol", 0);
    }

    @Override
    public Object convert(Object row, ObjectInspector rowOI) throws Exception {
        StructObjectInspector structOI = (StructObjectInspector)rowOI;
        List<? extends StructField> fields = structOI.getAllStructFieldRefs();
        Object[] converted = new Object[fields.size()];
        for (int i = 0; i < converted.length; ++i) {
            StructField fieldRef = fields.get(i);
            Object field = structOI.getStructFieldData(row, fieldRef);
            converted[i] = field == null ? null : SerDeUtils.toThriftPayload(field, fieldRef.getFieldObjectInspector(), this.protocol);
        }
        return converted;
    }

    @Override
    public void close() throws IOException {
    }
}

