/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.common;

import com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.IMetaStoreClient;
import com.linkedin.coral.$internal.org.apache.thrift.TException;
import com.linkedin.coral.common.HiveMetastoreClient;
import com.linkedin.coral.hive.metastore.api.Database;
import com.linkedin.coral.hive.metastore.api.Table;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMscAdapter
implements HiveMetastoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMscAdapter.class);
    private final IMetaStoreClient delegate;

    public HiveMscAdapter(IMetaStoreClient msc) {
        this.delegate = msc;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.delegate.getAllDatabases();
        }
        catch (TException e) {
            LOG.error("Failed to get all databases.", (Throwable)e);
            return ImmutableList.of();
        }
    }

    @Override
    public Database getDatabase(String dbName) {
        try {
            return this.delegate.getDatabase(dbName);
        }
        catch (TException e) {
            LOG.error(String.format("Failed to get database %s.", dbName), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAllTables(String dbName) {
        try {
            return this.delegate.getAllTables(dbName);
        }
        catch (TException e) {
            LOG.error(String.format("Failed to get all tables from database %s.", dbName), (Throwable)e);
            return ImmutableList.of();
        }
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        try {
            return this.delegate.getTable(dbName, tableName);
        }
        catch (TException e) {
            LOG.error(String.format("Failed to get table %s.%s.", dbName, tableName), (Throwable)e);
            return null;
        }
    }
}

