/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;

public class JoinSqlCallTransformer
extends SqlCallTransformer {
    private static final String TRANSFORM_OPERATOR = "transform";

    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().kind == SqlKind.JOIN && ((SqlJoin)sqlCall).getJoinType() == JoinType.COMMA;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        SqlJoin joinSqlCall = (SqlJoin)sqlCall;
        if (JoinSqlCallTransformer.isUnnestOperatorPresentInRightSqlNode(joinSqlCall.getRight())) {
            SqlCall unnestCall = (SqlCall)((SqlCall)joinSqlCall.getRight()).operand(0);
            if (JoinSqlCallTransformer.isSqlCallCorrelated(unnestCall)) {
                return JoinSqlCallTransformer.createCrossJoinSqlCall(joinSqlCall);
            }
            return joinSqlCall;
        }
        return JoinSqlCallTransformer.createCrossJoinSqlCall(joinSqlCall);
    }

    private static boolean isUnnestOperatorPresentInRightSqlNode(SqlNode rightSqlNode) {
        return rightSqlNode instanceof SqlCall && rightSqlNode.getKind() == SqlKind.AS && ((SqlCall)rightSqlNode).operand(0) instanceof SqlCall && ((SqlNode)((SqlCall)rightSqlNode).operand(0)).getKind() == SqlKind.UNNEST;
    }

    private static boolean isSqlCallCorrelated(SqlCall unnestSqlCall) {
        for (SqlNode operand : unnestSqlCall.getOperandList()) {
            if (operand instanceof SqlIdentifier) {
                return true;
            }
            if (!(operand instanceof SqlCall)) continue;
            if (((SqlCall)operand).getOperator().getName().equalsIgnoreCase(TRANSFORM_OPERATOR)) {
                return true;
            }
            if (!JoinSqlCallTransformer.isSqlCallCorrelated((SqlCall)operand)) continue;
            return true;
        }
        return false;
    }

    private static SqlCall createCrossJoinSqlCall(SqlJoin sqlCall) {
        return new SqlJoin(SqlImplementor.POS, sqlCall.getLeft(), SqlLiteral.createBoolean(false, SqlParserPos.ZERO), JoinType.CROSS.symbol(SqlImplementor.POS), sqlCall.getRight(), JoinConditionType.NONE.symbol(SqlParserPos.ZERO), null);
    }
}

