/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.linkedin.coral.calcite.$internal.org.codehaus.commons.compiler.CompileException;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.ClassBodyEvaluator;
import com.linkedin.coral.calcite.$internal.org.codehaus.janino.Scanner;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.runtime.Utilities;
import org.apache.calcite.util.Pair;

public class RexExecutable {
    private static final String GENERATED_CLASS_NAME = "Reducer";
    private final Function1<DataContext, Object[]> compiledFunction;
    private final String code;
    private DataContext dataContext;

    public RexExecutable(String code, Object reason) {
        this.code = code;
        this.compiledFunction = RexExecutable.compile(code, reason);
    }

    private static Function1<DataContext, Object[]> compile(String code, Object reason) {
        try {
            ClassBodyEvaluator cbe = new ClassBodyEvaluator();
            cbe.setClassName(GENERATED_CLASS_NAME);
            cbe.setExtendedClass(Utilities.class);
            cbe.setImplementedInterfaces(new Class[]{Function1.class, Serializable.class});
            cbe.setParentClassLoader(RexExecutable.class.getClassLoader());
            cbe.cook(new Scanner(null, new StringReader(code)));
            Class<?> c = cbe.getClazz();
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            return (Function1)constructor.newInstance(new Object[0]);
        }
        catch (CompileException | IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("While compiling " + reason, e);
        }
    }

    public void setDataContext(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    public void reduce(RexBuilder rexBuilder, List<RexNode> constExps, List<RexNode> reducedValues) {
        Object[] values;
        try {
            values = this.compiledFunction.apply(this.dataContext);
            assert (values.length == constExps.size());
            List<Object> valueList = Arrays.asList(values);
            for (Pair<RexNode, Object> value : Pair.zip(constExps, valueList)) {
                reducedValues.add(rexBuilder.makeLiteral(value.right, ((RexNode)value.left).getType(), true));
            }
        }
        catch (RuntimeException e) {
            reducedValues.addAll(constExps);
            values = new Object[constExps.size()];
        }
        Hook.EXPRESSION_REDUCER.run(Pair.of(this.code, values));
    }

    public Function1<DataContext, Object[]> getFunction() {
        return this.compiledFunction;
    }

    public Object[] execute() {
        return this.compiledFunction.apply(this.dataContext);
    }

    public String getSource() {
        return this.code;
    }
}

