/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import com.linkedin.coral.calcite.$internal.org.slf4j.Logger;
import com.linkedin.coral.calcite.$internal.org.slf4j.LoggerFactory;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Function0;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.util.Static;

public class ResultSetEnumerable<T>
extends AbstractEnumerable<T> {
    private final DataSource dataSource;
    private final String sql;
    private final Function1<ResultSet, Function0<T>> rowBuilderFactory;
    private final PreparedStatementEnricher preparedStatementEnricher;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetEnumerable.class);
    private Long queryStart;
    private long timeout;
    private boolean timeoutSetFailed;
    private static final Function1<ResultSet, Function0<Object>> AUTO_ROW_BUILDER_FACTORY = resultSet -> {
        int columnCount;
        ResultSetMetaData metaData;
        try {
            metaData = resultSet.getMetaData();
            columnCount = metaData.getColumnCount();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (columnCount == 1) {
            return () -> {
                try {
                    return resultSet.getObject(1);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return () -> {
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < columnCount; ++i) {
                    if (metaData.getColumnType(i + 1) == 93) {
                        long v = resultSet.getLong(i + 1);
                        if (v == 0L && resultSet.wasNull()) {
                            list.add(null);
                            continue;
                        }
                        list.add(v);
                        continue;
                    }
                    list.add(resultSet.getObject(i + 1));
                }
                return list.toArray();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        };
    };

    private ResultSetEnumerable(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory, PreparedStatementEnricher preparedStatementEnricher) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.rowBuilderFactory = rowBuilderFactory;
        this.preparedStatementEnricher = preparedStatementEnricher;
    }

    private ResultSetEnumerable(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
        this(dataSource, sql, rowBuilderFactory, null);
    }

    public static ResultSetEnumerable<Object> of(DataSource dataSource, String sql) {
        return ResultSetEnumerable.of(dataSource, sql, AUTO_ROW_BUILDER_FACTORY);
    }

    public static ResultSetEnumerable<Object> of(DataSource dataSource, String sql, Primitive[] primitives) {
        return ResultSetEnumerable.of(dataSource, sql, ResultSetEnumerable.primitiveRowBuilderFactory(primitives));
    }

    public static <T> ResultSetEnumerable<T> of(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
        return new ResultSetEnumerable<T>(dataSource, sql, rowBuilderFactory);
    }

    public static <T> ResultSetEnumerable<T> of(DataSource dataSource, String sql, Function1<ResultSet, Function0<T>> rowBuilderFactory, PreparedStatementEnricher consumer) {
        return new ResultSetEnumerable<T>(dataSource, sql, rowBuilderFactory, consumer);
    }

    public void setTimeout(DataContext context) {
        this.queryStart = (Long)context.get(DataContext.Variable.UTC_TIMESTAMP.camelName);
        Object timeout = context.get(DataContext.Variable.TIMEOUT.camelName);
        if (timeout instanceof Long) {
            this.timeout = (Long)timeout;
        } else {
            if (timeout != null) {
                LOGGER.debug("Variable.TIMEOUT should be `long`. Given value was {}", timeout);
            }
            this.timeout = 0L;
        }
    }

    public static PreparedStatementEnricher createEnricher(Integer[] indexes, DataContext context) {
        return preparedStatement -> {
            for (int i = 0; i < indexes.length; ++i) {
                int index = indexes[i];
                ResultSetEnumerable.setDynamicParam(preparedStatement, i + 1, context.get("?" + index));
            }
        };
    }

    private static void setDynamicParam(PreparedStatement preparedStatement, int i, Object value) throws SQLException {
        if (value == null) {
            preparedStatement.setObject(i, null, SqlType.ANY.id);
        } else if (value instanceof Timestamp) {
            preparedStatement.setTimestamp(i, (Timestamp)value);
        } else if (value instanceof Time) {
            preparedStatement.setTime(i, (Time)value);
        } else if (value instanceof String) {
            preparedStatement.setString(i, (String)value);
        } else if (value instanceof Integer) {
            preparedStatement.setInt(i, (Integer)value);
        } else if (value instanceof Double) {
            preparedStatement.setDouble(i, (Double)value);
        } else if (value instanceof Array) {
            preparedStatement.setArray(i, (Array)value);
        } else if (value instanceof BigDecimal) {
            preparedStatement.setBigDecimal(i, (BigDecimal)value);
        } else if (value instanceof Boolean) {
            preparedStatement.setBoolean(i, (Boolean)value);
        } else if (value instanceof Blob) {
            preparedStatement.setBlob(i, (Blob)value);
        } else if (value instanceof Byte) {
            preparedStatement.setByte(i, (Byte)value);
        } else if (value instanceof NClob) {
            preparedStatement.setNClob(i, (NClob)value);
        } else if (value instanceof Clob) {
            preparedStatement.setClob(i, (Clob)value);
        } else if (value instanceof byte[]) {
            preparedStatement.setBytes(i, (byte[])value);
        } else if (value instanceof Date) {
            preparedStatement.setDate(i, (Date)value);
        } else if (value instanceof Float) {
            preparedStatement.setFloat(i, ((Float)value).floatValue());
        } else if (value instanceof Long) {
            preparedStatement.setLong(i, (Long)value);
        } else if (value instanceof Ref) {
            preparedStatement.setRef(i, (Ref)value);
        } else if (value instanceof RowId) {
            preparedStatement.setRowId(i, (RowId)value);
        } else if (value instanceof Short) {
            preparedStatement.setShort(i, (Short)value);
        } else if (value instanceof URL) {
            preparedStatement.setURL(i, (URL)value);
        } else if (value instanceof SQLXML) {
            preparedStatement.setSQLXML(i, (SQLXML)value);
        } else {
            preparedStatement.setObject(i, value);
        }
    }

    @Override
    public Enumerator<T> enumerator() {
        if (this.preparedStatementEnricher == null) {
            return this.enumeratorBasedOnStatement();
        }
        return this.enumeratorBasedOnPreparedStatement();
    }

    private Enumerator<T> enumeratorBasedOnStatement() {
        Statement statement;
        Connection connection;
        block5: {
            connection = null;
            statement = null;
            connection = this.dataSource.getConnection();
            statement = connection.createStatement();
            this.setTimeoutIfPossible(statement);
            if (!statement.execute(this.sql)) break block5;
            ResultSet resultSet = statement.getResultSet();
            statement = null;
            connection = null;
            ResultSetEnumerator<T> resultSetEnumerator = new ResultSetEnumerator<T>(resultSet, this.rowBuilderFactory);
            this.closeIfPossible(connection, statement);
            return resultSetEnumerator;
        }
        try {
            Integer updateCount = statement.getUpdateCount();
            Enumerator<Integer> enumerator = Linq4j.singletonEnumerator(updateCount);
            this.closeIfPossible(connection, statement);
            return enumerator;
        }
        catch (SQLException e) {
            try {
                throw (RuntimeException)Static.RESOURCE.exceptionWhilePerformingQueryOnJdbcSubSchema(this.sql).ex(e);
            }
            catch (Throwable throwable) {
                this.closeIfPossible(connection, statement);
                throw throwable;
            }
        }
    }

    private Enumerator<T> enumeratorBasedOnPreparedStatement() {
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            connection = null;
            preparedStatement = null;
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(this.sql);
            this.setTimeoutIfPossible(preparedStatement);
            this.preparedStatementEnricher.enrich(preparedStatement);
            if (!preparedStatement.execute()) break block5;
            ResultSet resultSet = preparedStatement.getResultSet();
            preparedStatement = null;
            connection = null;
            ResultSetEnumerator<T> resultSetEnumerator = new ResultSetEnumerator<T>(resultSet, this.rowBuilderFactory);
            this.closeIfPossible(connection, preparedStatement);
            return resultSetEnumerator;
        }
        try {
            Integer updateCount = preparedStatement.getUpdateCount();
            Enumerator<Integer> enumerator = Linq4j.singletonEnumerator(updateCount);
            this.closeIfPossible(connection, preparedStatement);
            return enumerator;
        }
        catch (SQLException e) {
            try {
                throw (RuntimeException)Static.RESOURCE.exceptionWhilePerformingQueryOnJdbcSubSchema(this.sql).ex(e);
            }
            catch (Throwable throwable) {
                this.closeIfPossible(connection, preparedStatement);
                throw throwable;
            }
        }
    }

    private void setTimeoutIfPossible(Statement statement) throws SQLException {
        block5: {
            if (this.timeout == 0L) {
                return;
            }
            long now = System.currentTimeMillis();
            long secondsLeft = (this.queryStart + this.timeout - now) / 1000L;
            if (secondsLeft <= 0L) {
                throw Static.RESOURCE.queryExecutionTimeoutReached(String.valueOf(this.timeout), String.valueOf(Instant.ofEpochMilli(this.queryStart))).ex();
            }
            if (secondsLeft > Integer.MAX_VALUE) {
                return;
            }
            try {
                statement.setQueryTimeout((int)secondsLeft);
            }
            catch (SQLFeatureNotSupportedException e) {
                if (this.timeoutSetFailed || !LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Failed to set query timeout " + secondsLeft + " seconds", e);
                this.timeoutSetFailed = true;
            }
        }
    }

    private void closeIfPossible(Connection connection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static Function1<ResultSet, Function0<Object>> primitiveRowBuilderFactory(Primitive[] primitives) {
        return resultSet -> {
            int columnCount;
            try {
                ResultSetMetaData metaData = resultSet.getMetaData();
                columnCount = metaData.getColumnCount();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            assert (columnCount == primitives.length);
            if (columnCount == 1) {
                return () -> {
                    try {
                        return resultSet.getObject(1);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            return () -> {
                try {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < columnCount; ++i) {
                        list.add(primitives[i].jdbcGet((ResultSet)resultSet, i + 1));
                    }
                    return list.toArray();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            };
        };
    }

    public static interface PreparedStatementEnricher {
        public void enrich(PreparedStatement var1) throws SQLException;
    }

    private static class ResultSetEnumerator<T>
    implements Enumerator<T> {
        private final Function0<T> rowBuilder;
        private ResultSet resultSet;

        ResultSetEnumerator(ResultSet resultSet, Function1<ResultSet, Function0<T>> rowBuilderFactory) {
            this.resultSet = resultSet;
            this.rowBuilder = rowBuilderFactory.apply(resultSet);
        }

        @Override
        public T current() {
            return this.rowBuilder.apply();
        }

        @Override
        public boolean moveNext() {
            try {
                return this.resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void reset() {
            try {
                this.resultSet.beforeFirst();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            ResultSet savedResultSet = this.resultSet;
            if (savedResultSet != null) {
                try {
                    this.resultSet = null;
                    Statement statement = savedResultSet.getStatement();
                    savedResultSet.close();
                    if (statement != null) {
                        Connection connection = statement.getConnection();
                        statement.close();
                        if (connection != null) {
                            connection.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

