/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.http.HttpClient;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.core.tracing.opentelemetry.OpenTelemetryTracingOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.core.util.TracingOptions;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureFileSystem;
import io.trino.filesystem.azure.AzureFileSystemConfig;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class AzureFileSystemFactory
implements TrinoFileSystemFactory {
    private final AzureAuth auth;
    private final String endpoint;
    private final DataSize readBlockSize;
    private final DataSize writeBlockSize;
    private final int maxWriteConcurrency;
    private final DataSize maxSingleUploadSize;
    private final TracingOptions tracingOptions;
    private final OkHttpClient okHttpClient;
    private final HttpClient httpClient;

    @Inject
    public AzureFileSystemFactory(OpenTelemetry openTelemetry, AzureAuth azureAuth, AzureFileSystemConfig config) {
        this(openTelemetry, azureAuth, config.getEndpoint(), config.getReadBlockSize(), config.getWriteBlockSize(), config.getMaxWriteConcurrency(), config.getMaxSingleUploadSize(), config.getMaxHttpRequests(), config.getApplicationId());
    }

    public AzureFileSystemFactory(OpenTelemetry openTelemetry, AzureAuth azureAuth, String endpoint, DataSize readBlockSize, DataSize writeBlockSize, int maxWriteConcurrency, DataSize maxSingleUploadSize, int maxHttpRequests, String applicationId) {
        this.auth = Objects.requireNonNull(azureAuth, "azureAuth is null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
        this.readBlockSize = Objects.requireNonNull(readBlockSize, "readBlockSize is null");
        this.writeBlockSize = Objects.requireNonNull(writeBlockSize, "writeBlockSize is null");
        Preconditions.checkArgument((maxWriteConcurrency >= 0 ? 1 : 0) != 0, (Object)"maxWriteConcurrency is negative");
        this.maxWriteConcurrency = maxWriteConcurrency;
        this.maxSingleUploadSize = Objects.requireNonNull(maxSingleUploadSize, "maxSingleUploadSize is null");
        this.tracingOptions = new OpenTelemetryTracingOptions().setOpenTelemetry(openTelemetry);
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(maxHttpRequests);
        dispatcher.setMaxRequestsPerHost(maxHttpRequests);
        this.okHttpClient = new OkHttpClient.Builder().dispatcher(dispatcher).build();
        HttpClientOptions clientOptions = new HttpClientOptions();
        clientOptions.setTracingOptions(this.tracingOptions);
        clientOptions.setApplicationId(applicationId);
        this.httpClient = AzureFileSystemFactory.createAzureHttpClient(this.okHttpClient, clientOptions);
    }

    @PreDestroy
    public void destroy() {
        this.okHttpClient.dispatcher().executorService().shutdownNow();
        this.okHttpClient.connectionPool().evictAll();
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new AzureFileSystem(this.httpClient, this.tracingOptions, this.auth, this.endpoint, this.readBlockSize, this.writeBlockSize, this.maxWriteConcurrency, this.maxSingleUploadSize);
    }

    public static HttpClient createAzureHttpClient(OkHttpClient okHttpClient, HttpClientOptions clientOptions) {
        Integer poolSize = clientOptions.getMaximumConnectionPoolSize();
        int maximumConnectionPoolSize = poolSize != null && poolSize > 0 ? poolSize : 5;
        return new OkHttpAsyncHttpClientBuilder(okHttpClient).proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectionTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).readTimeout(clientOptions.getReadTimeout()).connectionPool(new ConnectionPool(maximumConnectionPoolSize, clientOptions.getConnectionIdleTimeout().toMillis(), TimeUnit.MILLISECONDS)).build();
    }
}

