/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.models.DataLakeStorageExceptionInternal;
import com.azure.storage.file.datalake.implementation.models.FileSystem;
import com.azure.storage.file.datalake.implementation.models.FileSystemList;
import com.azure.storage.file.datalake.implementation.models.ServicesListFileSystemsHeaders;
import com.azure.storage.file.datalake.implementation.util.ModelHelper;
import reactor.core.publisher.Mono;

public final class ServicesImpl {
    private final ServicesService service;
    private final AzureDataLakeStorageRestAPIImpl client;

    ServicesImpl(AzureDataLakeStorageRestAPIImpl client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<FileSystem>> listFileSystemsSinglePageAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        String resource = "account";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFileSystems(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, (Object)((ServicesListFileSystemsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<FileSystem>> listFileSystemsSinglePageAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        String resource = "account";
        String accept = "application/json";
        return this.service.listFileSystems(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, (Object)((ServicesListFileSystemsHeaders)res.getDeserializedHeaders())));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystem> listFileSystemsAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        return new PagedFlux(() -> this.listFileSystemsSinglePageAsync(prefix, continuation, maxResults, requestId, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystem> listFileSystemsAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        return new PagedFlux(() -> this.listFileSystemsSinglePageAsync(prefix, continuation, maxResults, requestId, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<FileSystem>> listFileSystemsNoCustomHeadersSinglePageAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        String resource = "account";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFileSystemsNoCustomHeaders(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", (Context)context)).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<FileSystem>> listFileSystemsNoCustomHeadersSinglePageAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        String resource = "account";
        String accept = "application/json";
        return this.service.listFileSystemsNoCustomHeaders(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", context).onErrorMap(DataLakeStorageExceptionInternal.class, ModelHelper::mapToDataLakeStorageException).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystem> listFileSystemsNoCustomHeadersAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        return new PagedFlux(() -> this.listFileSystemsNoCustomHeadersSinglePageAsync(prefix, continuation, maxResults, requestId, timeout));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystem> listFileSystemsNoCustomHeadersAsync(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        return new PagedFlux(() -> this.listFileSystemsNoCustomHeadersSinglePageAsync(prefix, continuation, maxResults, requestId, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<FileSystem> listFileSystemsSinglePage(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        try {
            String resource = "account";
            String accept = "application/json";
            ResponseBase<ServicesListFileSystemsHeaders, FileSystemList> res = this.service.listFileSystemsSync(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", Context.NONE);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, (Object)((ServicesListFileSystemsHeaders)res.getDeserializedHeaders()));
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<FileSystem> listFileSystemsSinglePage(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        try {
            String resource = "account";
            String accept = "application/json";
            ResponseBase<ServicesListFileSystemsHeaders, FileSystemList> res = this.service.listFileSystemsSync(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, (Object)((ServicesListFileSystemsHeaders)res.getDeserializedHeaders()));
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystem> listFileSystems(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        return new PagedIterable(() -> this.listFileSystemsSinglePage(prefix, continuation, maxResults, requestId, timeout, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystem> listFileSystems(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        return new PagedIterable(() -> this.listFileSystemsSinglePage(prefix, continuation, maxResults, requestId, timeout, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<FileSystem> listFileSystemsNoCustomHeadersSinglePage(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        try {
            String resource = "account";
            String accept = "application/json";
            Response<FileSystemList> res = this.service.listFileSystemsNoCustomHeadersSync(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", Context.NONE);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, null);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<FileSystem> listFileSystemsNoCustomHeadersSinglePage(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        try {
            String resource = "account";
            String accept = "application/json";
            Response<FileSystemList> res = this.service.listFileSystemsNoCustomHeadersSync(this.client.getUrl(), "account", prefix, continuation, maxResults, requestId, timeout, this.client.getVersion(), "application/json", context);
            return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FileSystemList)res.getValue()).getFilesystems(), null, null);
        }
        catch (DataLakeStorageExceptionInternal internalException) {
            throw ModelHelper.mapToDataLakeStorageException(internalException);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystem> listFileSystemsNoCustomHeaders(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout) {
        return new PagedIterable(() -> this.listFileSystemsNoCustomHeadersSinglePage(prefix, continuation, maxResults, requestId, timeout, Context.NONE));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FileSystem> listFileSystemsNoCustomHeaders(String prefix, String continuation, Integer maxResults, String requestId, Integer timeout, Context context) {
        return new PagedIterable(() -> this.listFileSystemsNoCustomHeadersSinglePage(prefix, continuation, maxResults, requestId, timeout, context));
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureDataLakeStorage")
    public static interface ServicesService {
        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<ResponseBase<ServicesListFileSystemsHeaders, FileSystemList>> listFileSystems(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Mono<Response<FileSystemList>> listFileSystemsNoCustomHeaders(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public ResponseBase<ServicesListFileSystemsHeaders, FileSystemList> listFileSystemsSync(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="/")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=DataLakeStorageExceptionInternal.class)
        public Response<FileSystemList> listFileSystemsNoCustomHeadersSync(@HostParam(value="url") String var1, @QueryParam(value="resource") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="continuation") String var4, @QueryParam(value="maxResults") Integer var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

