/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetMetadataConverter;
import io.trino.parquet.ParquetValidationUtils;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.reader.MetadataReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetMetadata {
    private static final Logger log = Logger.get(ParquetMetadata.class);
    private final FileMetaData parquetMetadata;
    private final ParquetDataSourceId dataSourceId;
    private final FileMetadata fileMetadata;

    public ParquetMetadata(FileMetaData parquetMetadata, ParquetDataSourceId dataSourceId) throws ParquetCorruptionException {
        this.fileMetadata = new FileMetadata(ParquetMetadata.readMessageType(parquetMetadata, dataSourceId), ParquetMetadata.keyValueMetaData(parquetMetadata), parquetMetadata.getCreated_by());
        this.parquetMetadata = parquetMetadata;
        this.dataSourceId = Objects.requireNonNull(dataSourceId, "dataSourceId is null");
    }

    public FileMetadata getFileMetaData() {
        return this.fileMetadata;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parquetMetadata", (Object)this.parquetMetadata).toString();
    }

    public List<BlockMetadata> getBlocks() throws ParquetCorruptionException {
        return this.getBlocks(0L, Long.MAX_VALUE);
    }

    public List<BlockMetadata> getBlocks(long splitStart, long splitLength) throws ParquetCorruptionException {
        List schema = this.parquetMetadata.getSchema();
        ParquetValidationUtils.validateParquet(!schema.isEmpty(), this.dataSourceId, "Schema is empty", new Object[0]);
        MessageType messageType = ParquetMetadata.readParquetSchema(schema);
        ArrayList<BlockMetadata> blocks = new ArrayList<BlockMetadata>();
        List rowGroups = this.parquetMetadata.getRow_groups();
        if (rowGroups != null) {
            for (RowGroup rowGroup : rowGroups) {
                long rowGroupStart;
                boolean splitContainsRowGroup;
                if (rowGroup.isSetFile_offset() && !(splitContainsRowGroup = splitStart <= (rowGroupStart = rowGroup.getFile_offset()) && rowGroupStart < splitStart + splitLength)) continue;
                List columns = rowGroup.getColumns();
                ParquetValidationUtils.validateParquet(!columns.isEmpty(), this.dataSourceId, "No columns in row group: %s", rowGroup);
                String filePath = ((ColumnChunk)columns.get(0)).getFile_path();
                ImmutableList.Builder columnMetadataBuilder = ImmutableList.builderWithExpectedSize((int)columns.size());
                for (ColumnChunk columnChunk : columns) {
                    ParquetValidationUtils.validateParquet(filePath == null && columnChunk.getFile_path() == null || filePath != null && filePath.equals(columnChunk.getFile_path()), this.dataSourceId, "all column chunks of the same row group must be in the same file", new Object[0]);
                    ColumnMetaData metaData = columnChunk.meta_data;
                    String[] path = (String[])metaData.path_in_schema.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
                    ColumnPath columnPath = ColumnPath.get((String[])path);
                    PrimitiveType primitiveType = messageType.getType(columnPath.toArray()).asPrimitiveType();
                    ColumnChunkMetadata column = ColumnChunkMetadata.get(columnPath, primitiveType, CompressionCodecName.fromParquet((CompressionCodec)metaData.codec), ParquetMetadataConverter.convertEncodingStats(metaData.encoding_stats), ParquetMetadata.readEncodings(metaData.encodings), MetadataReader.readStats(Optional.ofNullable(this.parquetMetadata.getCreated_by()), Optional.ofNullable(metaData.statistics), primitiveType), metaData.data_page_offset, metaData.dictionary_page_offset, metaData.num_values, metaData.total_compressed_size, metaData.total_uncompressed_size);
                    column.setColumnIndexReference(ParquetMetadataConverter.toColumnIndexReference(columnChunk));
                    column.setOffsetIndexReference(ParquetMetadataConverter.toOffsetIndexReference(columnChunk));
                    column.setBloomFilterOffset(metaData.bloom_filter_offset);
                    columnMetadataBuilder.add((Object)column);
                }
                blocks.add(new BlockMetadata(rowGroup.getNum_rows(), (List<ColumnChunkMetadata>)columnMetadataBuilder.build()));
            }
        }
        return blocks;
    }

    @VisibleForTesting
    public FileMetaData getParquetMetadata() {
        return this.parquetMetadata;
    }

    private static MessageType readParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        ParquetMetadata.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static void readTypeSchema(Types.GroupBuilder<?> builder, Iterator<SchemaElement> schemaIterator, int typeCount) {
        for (int i = 0; i < typeCount; ++i) {
            Types.GroupBuilder typeBuilder;
            SchemaElement element = schemaIterator.next();
            if (element.type == null) {
                typeBuilder = builder.group(Type.Repetition.valueOf((String)element.repetition_type.name()));
                ParquetMetadata.readTypeSchema(typeBuilder, schemaIterator, element.num_children);
            } else {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(ParquetMetadataConverter.getPrimitive(element.type), Type.Repetition.valueOf((String)element.repetition_type.name()));
                if (element.isSetType_length()) {
                    primitiveBuilder.length(element.type_length);
                }
                if (element.isSetPrecision()) {
                    primitiveBuilder.precision(element.precision);
                }
                if (element.isSetScale()) {
                    primitiveBuilder.scale(element.scale);
                }
                typeBuilder = primitiveBuilder;
            }
            LogicalTypeAnnotation annotationFromLogicalType = null;
            if (element.isSetLogicalType()) {
                annotationFromLogicalType = ParquetMetadataConverter.getLogicalTypeAnnotation(element.logicalType);
                typeBuilder.as(annotationFromLogicalType);
            }
            if (element.isSetConverted_type()) {
                LogicalTypeAnnotation annotationFromConvertedType = ParquetMetadataConverter.getLogicalTypeAnnotation(element.converted_type, element);
                if (annotationFromLogicalType != null) {
                    if (annotationFromLogicalType.toOriginalType() != annotationFromConvertedType.toOriginalType()) {
                        log.warn("Converted type and logical type metadata map to different OriginalType (convertedType: %s, logical type: %s). Using value in converted type.", new Object[]{element.converted_type, element.logicalType});
                        typeBuilder.as(annotationFromConvertedType);
                    }
                } else {
                    typeBuilder.as(annotationFromConvertedType);
                }
            }
            if (element.isSetField_id()) {
                typeBuilder.id(element.field_id);
            }
            typeBuilder.named(element.name.toLowerCase(Locale.ENGLISH));
        }
    }

    private static Set<org.apache.parquet.column.Encoding> readEncodings(List<Encoding> encodings) {
        HashSet<org.apache.parquet.column.Encoding> columnEncodings = new HashSet<org.apache.parquet.column.Encoding>();
        for (Encoding encoding : encodings) {
            columnEncodings.add(ParquetMetadataConverter.getEncoding(encoding));
        }
        return Collections.unmodifiableSet(columnEncodings);
    }

    private static MessageType readMessageType(FileMetaData parquetMetadata, ParquetDataSourceId dataSourceId) throws ParquetCorruptionException {
        List schema = parquetMetadata.getSchema();
        ParquetValidationUtils.validateParquet(!schema.isEmpty(), dataSourceId, "Schema is empty", new Object[0]);
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = (SchemaElement)schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        ParquetMetadata.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static Map<String, String> keyValueMetaData(FileMetaData parquetMetadata) {
        if (parquetMetadata.getKey_value_metadata() == null) {
            return ImmutableMap.of();
        }
        return (Map)parquetMetadata.getKey_value_metadata().stream().collect(ImmutableMap.toImmutableMap(KeyValue::getKey, KeyValue::getValue, (string, second) -> second));
    }
}

