/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.ValuesReader;

public class ApacheParquetValueDecoders {
    private ApacheParquetValueDecoders() {
    }

    private static void initialize(SimpleSliceInputStream input, ValuesReader reader, int elementSizeInBytes) {
        byte[] buffer = input.readBytes();
        try {
            int valueCount = buffer.length / elementSizeInBytes;
            reader.initFromPage(valueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, 0, buffer.length)}));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final class FloatApacheParquetValueDecoder
    implements ValueDecoder<int[]> {
        private final ValuesReader delegate;

        public FloatApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate, 4);
        }

        @Override
        public void read(int[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Float.floatToIntBits(this.delegate.readFloat());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class DoubleApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private final ValuesReader delegate;

        public DoubleApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate, 8);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Double.doubleToLongBits(this.delegate.readDouble());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class BooleanApacheParquetValueDecoder
    implements ValueDecoder<byte[]> {
        private final ValuesReader delegate;

        public BooleanApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            byte[] buffer = input.readBytes();
            try {
                int valueCount = buffer.length * 8;
                this.delegate.initFromPage(valueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, 0, buffer.length)}));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.castToByte(this.delegate.readBoolean());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }
}

