/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ShortDecimalFixedWidthByteArrayBatchDecoder;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.type.Int128;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public final class PlainValueDecoders {
    private PlainValueDecoders() {
    }

    public static final class FixedLengthPlainValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final int typeLength;
        private SimpleSliceInputStream input;

        public FixedLengthPlainValueDecoder(int typeLength) {
            this.typeLength = typeLength;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(BinaryBuffer values, int offset, int length) {
            values.addChunk(this.input.readSlice(this.typeLength * length));
            int[] outputOffsets = values.getOffsets();
            int inputLength = outputOffsets[offset] + this.typeLength;
            for (int i = offset; i < offset + length; ++i) {
                outputOffsets[i + 1] = inputLength;
                inputLength += this.typeLength;
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * this.typeLength);
        }
    }

    public static final class Int96TimestampPlainValueDecoder
    implements ValueDecoder<int[]> {
        private static final int LENGTH = 12;
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(int[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                DecodedTimestamp timestamp = ParquetTimestampUtils.decodeInt96Timestamp(this.input.readLongUnchecked(), this.input.readIntUnchecked());
                Fixed12Block.encodeFixed12((long)timestamp.epochSeconds(), (int)timestamp.nanosOfSecond(), (int[])values, (int)i);
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 12);
        }
    }

    public static final class UuidPlainValueDecoder
    implements ValueDecoder<long[]> {
        private static final int UUID_SIZE = 16;
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(long[] values, int offset, int length) {
            int endOffset = (offset + length) * 2;
            for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
                values[currentOutputOffset] = this.input.readLong();
                values[currentOutputOffset + 1] = this.input.readLong();
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 16);
        }
    }

    public static final class LongDecimalPlainValueDecoder
    implements ValueDecoder<long[]> {
        private final int typeLength;
        private final byte[] inputBytes;
        private SimpleSliceInputStream input;

        public LongDecimalPlainValueDecoder(int typeLength) {
            Preconditions.checkArgument((typeLength > 0 && typeLength <= 16 ? 1 : 0) != 0, (String)"typeLength %s should be in range (1-16) for a long decimal", (int)typeLength);
            this.typeLength = typeLength;
            this.inputBytes = new byte[typeLength];
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(long[] values, int offset, int length) {
            int endOffset = (offset + length) * 2;
            for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
                this.input.readBytes(Slices.wrappedBuffer((byte[])this.inputBytes), 0, this.typeLength);
                Int128 value = Int128.fromBigEndian((byte[])this.inputBytes);
                values[currentOutputOffset] = value.getHigh();
                values[currentOutputOffset + 1] = value.getLow();
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * this.typeLength);
        }
    }

    public static final class ShortDecimalFixedLengthByteArrayDecoder
    implements ValueDecoder<long[]> {
        private final int typeLength;
        private final ColumnDescriptor descriptor;
        private final ShortDecimalFixedWidthByteArrayBatchDecoder decimalValueDecoder;
        private SimpleSliceInputStream input;

        public ShortDecimalFixedLengthByteArrayDecoder(ColumnDescriptor descriptor) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)descriptor.getPrimitiveType().getLogicalTypeAnnotation();
            Preconditions.checkArgument((decimalAnnotation.getPrecision() <= 18 ? 1 : 0) != 0, (String)"Decimal type %s is not a short decimal", (Object)decimalAnnotation);
            this.typeLength = descriptor.getPrimitiveType().getTypeLength();
            Preconditions.checkArgument((this.typeLength > 0 && this.typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)descriptor);
            this.descriptor = descriptor;
            this.decimalValueDecoder = new ShortDecimalFixedWidthByteArrayBatchDecoder(Math.min(this.typeLength, 8));
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(long[] values, int offset, int length) {
            if (this.typeLength <= 8) {
                this.decimalValueDecoder.getShortDecimalValues(this.input, values, offset, length);
                return;
            }
            int extraBytesLength = this.typeLength - 8;
            byte[] inputBytes = this.input.getByteArray();
            int inputBytesOffset = this.input.getByteArrayOffset();
            for (int i = offset; i < offset + length; ++i) {
                ParquetTypeUtils.checkBytesFitInShortDecimal(inputBytes, inputBytesOffset, extraBytesLength, this.descriptor);
                values[i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, inputBytesOffset + extraBytesLength, 8);
                inputBytesOffset += this.typeLength;
            }
            this.input.skip(length * this.typeLength);
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * this.typeLength);
        }
    }

    public static final class IntToBytePlainValueDecoder
    implements ValueDecoder<byte[]> {
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.toByteExact(this.input.readIntUnchecked());
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 4);
        }
    }

    public static final class IntToShortPlainValueDecoder
    implements ValueDecoder<short[]> {
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(short[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.toShortExact(this.input.readIntUnchecked());
            }
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 4);
        }
    }

    public static final class IntPlainValueDecoder
    implements ValueDecoder<int[]> {
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(int[] values, int offset, int length) {
            this.input.readInts(values, offset, length);
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 4);
        }
    }

    public static final class LongPlainValueDecoder
    implements ValueDecoder<long[]> {
        private SimpleSliceInputStream input;

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
        }

        @Override
        public void read(long[] values, int offset, int length) {
            this.input.readLongs(values, offset, length);
        }

        @Override
        public void skip(int n) {
            this.input.skip(n * 8);
        }
    }
}

