/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.airlift.slice.SizeOf;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.IntArrayBlock;
import java.util.List;
import java.util.Optional;

public class IntColumnAdapter
implements ColumnAdapter<int[]> {
    public static final IntColumnAdapter INT_ADAPTER = new IntColumnAdapter();

    @Override
    public int[] createBuffer(int size) {
        return new int[size];
    }

    @Override
    public Block createNonNullBlock(int[] values) {
        return new IntArrayBlock(values.length, Optional.empty(), values);
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, int[] values) {
        return new IntArrayBlock(values.length, Optional.of(nulls), values);
    }

    @Override
    public void copyValue(int[] source, int sourceIndex, int[] destination, int destinationIndex) {
        destination[destinationIndex] = source[sourceIndex];
    }

    @Override
    public void decodeDictionaryIds(int[] values, int offset, int length, int[] ids, int[] dictionary) {
        for (int i = 0; i < length; ++i) {
            values[offset + i] = dictionary[ids[i]];
        }
    }

    @Override
    public long getSizeInBytes(int[] values) {
        return SizeOf.sizeOf((int[])values);
    }

    @Override
    public int[] merge(List<int[]> buffers) {
        return IntColumnAdapter.concatIntArrays(buffers);
    }

    static int[] concatIntArrays(List<int[]> buffers) {
        long resultSize = 0L;
        for (int[] buffer : buffers) {
            resultSize += (long)buffer.length;
        }
        int[] result = new int[Math.toIntExact(resultSize)];
        int offset = 0;
        for (int[] buffer : buffers) {
            System.arraycopy(buffer, 0, result, offset, buffer.length);
            offset += buffer.length;
        }
        return result;
    }
}

