/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimestampWithTimeZoneType;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampTzMillisValueWriter
extends PrimitiveValueWriter {
    public TimestampTzMillisValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (mayHaveNull && block.isNull(i)) continue;
            long millis = DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong(block, i));
            valuesWriter.writeLong(millis);
            statistics.updateStats(millis);
        }
    }
}

