/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Inject;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.MergeJdbcPageSource;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.RecordPageSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JdbcPageSourceProvider
implements ConnectorPageSourceProvider {
    private final JdbcClient jdbcClient;
    private final ConnectorRecordSetProvider recordSetProvider;

    @Inject
    public JdbcPageSourceProvider(JdbcClient jdbcClient, ConnectorRecordSetProvider recordSetProvider) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        if (table instanceof JdbcProcedureHandle) {
            JdbcProcedureHandle procedureHandle = (JdbcProcedureHandle)table;
            return new RecordPageSource(this.recordSetProvider.getRecordSet(transaction, session, split, (ConnectorTableHandle)procedureHandle, columns));
        }
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Optional mergeRowId = (Optional)columns.stream().map(JdbcColumnHandle.class::cast).filter(column -> column.getColumnName().equalsIgnoreCase("$merge_row_id")).collect(MoreCollectors.toOptional());
        if (mergeRowId.isEmpty()) {
            return new RecordPageSource(this.recordSetProvider.getRecordSet(transaction, session, split, (ConnectorTableHandle)tableHandle, columns));
        }
        return this.createMergePageSource(transaction, session, split, columns, tableHandle, mergeRowId);
    }

    private MergeJdbcPageSource createMergePageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, JdbcTableHandle tableHandle, Optional<JdbcColumnHandle> mergeRowId) {
        List<JdbcColumnHandle> primaryKeys = this.jdbcClient.getPrimaryKeys(session, tableHandle.getRequiredNamedRelation().getRemoteTableName());
        List<JdbcColumnHandle> scanColumns = JdbcPageSourceProvider.getScanColumns(session, this.jdbcClient, tableHandle, primaryKeys);
        ImmutableList.Builder columnAdaptationsBuilder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            if (columnHandle.equals((Object)mergeRowId.get())) {
                columnAdaptationsBuilder.add((Object)JdbcPageSourceProvider.buildMergeIdColumnAdaptation(scanColumns, primaryKeys));
                continue;
            }
            columnAdaptationsBuilder.add((Object)new MergeJdbcPageSource.SourceColumn(scanColumns.indexOf(columnHandle)));
        }
        JdbcTableHandle newTableHandle = new JdbcTableHandle(tableHandle.getRelationHandle(), tableHandle.getConstraint(), tableHandle.getConstraintExpressions(), tableHandle.getSortOrder(), tableHandle.getLimit(), Optional.of(scanColumns), tableHandle.getOtherReferencedTables(), tableHandle.getNextSyntheticColumnId(), tableHandle.getAuthorization(), tableHandle.getUpdateAssignments());
        return new MergeJdbcPageSource((ConnectorPageSource)new RecordPageSource(this.recordSetProvider.getRecordSet(transaction, session, split, (ConnectorTableHandle)newTableHandle, scanColumns)), (List<MergeJdbcPageSource.ColumnAdaptation>)columnAdaptationsBuilder.build());
    }

    private static List<JdbcColumnHandle> getScanColumns(ConnectorSession session, JdbcClient jdbcClient, JdbcTableHandle tableHandle, List<JdbcColumnHandle> primaryKeys) {
        List<JdbcColumnHandle> allTableColumns = jdbcClient.getColumns(session, tableHandle.getRequiredNamedRelation().getSchemaTableName(), tableHandle.getRequiredNamedRelation().getRemoteTableName());
        ImmutableList.Builder scanColumnsBuilder = ImmutableList.builder();
        scanColumnsBuilder.addAll(allTableColumns);
        for (JdbcColumnHandle primaryKey : primaryKeys) {
            if (allTableColumns.contains(primaryKey)) continue;
            scanColumnsBuilder.add((Object)primaryKey);
        }
        return scanColumnsBuilder.build();
    }

    private static MergeJdbcPageSource.ColumnAdaptation buildMergeIdColumnAdaptation(List<JdbcColumnHandle> scanColumns, List<JdbcColumnHandle> primaryKeys) {
        List mergeRowIdSourceChannels = (List)primaryKeys.stream().map(scanColumns::indexOf).peek(channel -> Preconditions.checkArgument((channel >= 0 ? 1 : 0) != 0, (Object)"There are primary keys not exist in scan columns")).collect(ImmutableList.toImmutableList());
        return new MergeJdbcPageSource.MergedRowAdaptation(mergeRowIdSourceChannels);
    }
}

