/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypeParameterPattern;
import io.trino.spi.type.ParameterKind;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;

public class LongTypeParameter
extends TypeParameterPattern {
    private final long value;
    private final Pattern<TypeSignatureParameter> pattern;

    public LongTypeParameter(long value) {
        this.value = value;
        this.pattern = Pattern.typeOf(TypeSignatureParameter.class).with(LongTypeParameter.value().equalTo((Object)value));
    }

    @Override
    public Pattern<? extends TypeSignatureParameter> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongTypeParameter that = (LongTypeParameter)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    public static Property<TypeSignatureParameter, ?, Long> value() {
        return Property.optionalProperty((String)"value", parameter -> {
            if (parameter.getKind() != ParameterKind.LONG) {
                return Optional.empty();
            }
            return Optional.of(parameter.getLongLiteral());
        });
    }
}

