/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.WriteFunction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public interface BooleanWriteFunction
extends WriteFunction {
    @Override
    default public Class<?> getJavaType() {
        return Boolean.TYPE;
    }

    public void set(PreparedStatement var1, int var2, boolean var3) throws SQLException;

    public static BooleanWriteFunction of(final int nullJdbcType, final BooleanWriteFunctionImplementation implementation) {
        Objects.requireNonNull(implementation, "implementation is null");
        return new BooleanWriteFunction(){

            @Override
            public void set(PreparedStatement statement, int index, boolean value) throws SQLException {
                implementation.set(statement, index, value);
            }

            @Override
            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setNull(index, nullJdbcType);
            }
        };
    }

    @FunctionalInterface
    public static interface BooleanWriteFunctionImplementation {
        public void set(PreparedStatement var1, int var2, boolean var3) throws SQLException;
    }
}

