/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro;

import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.hive.formats.avro.AvroCompressionKind;
import io.trino.hive.formats.avro.AvroPagePositionDataWriter;
import io.trino.hive.formats.avro.AvroTypeException;
import io.trino.hive.formats.avro.AvroTypeManager;
import io.trino.hive.formats.avro.AvroTypeUtils;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;

public class AvroFileWriter
implements Closeable {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(AvroFileWriter.class);
    private final AvroPagePositionDataWriter pagePositionDataWriter;
    private final DataFileWriter<Integer> pagePositionFileWriter;

    public AvroFileWriter(OutputStream rawOutput, Schema schema, AvroTypeManager avroTypeManager, AvroCompressionKind compressionKind, Map<String, String> fileMetadata, List<String> names, List<Type> types, boolean resolveUsingLowerCaseFieldsInSchema) throws IOException, AvroTypeException {
        Verify.verify((boolean)compressionKind.isSupportedLocally(), (String)"compression kind must be supported locally: %s", (Object)((Object)compressionKind));
        this.pagePositionDataWriter = resolveUsingLowerCaseFieldsInSchema ? new AvroPagePositionDataWriter(AvroTypeUtils.lowerCaseAllFieldsForWriter(schema), avroTypeManager, names, types) : new AvroPagePositionDataWriter(schema, avroTypeManager, names, types);
        try {
            DataFileWriter fileWriter = new DataFileWriter((DatumWriter)this.pagePositionDataWriter).setCodec(compressionKind.getCodecFactory());
            fileMetadata.forEach((arg_0, arg_1) -> ((DataFileWriter)fileWriter).setMeta(arg_0, arg_1));
            this.pagePositionFileWriter = fileWriter.create(schema, rawOutput);
        }
        catch (org.apache.avro.AvroTypeException e) {
            throw new AvroTypeException(e);
        }
        catch (AvroRuntimeException e) {
            throw new IOException(e);
        }
    }

    public void write(Page page) throws IOException {
        this.pagePositionDataWriter.setPage(page);
        for (int pos = 0; pos < page.getPositionCount(); ++pos) {
            try {
                this.pagePositionFileWriter.append((Object)pos);
                continue;
            }
            catch (RuntimeException e) {
                throw new IOException("Error writing to avro file", e);
            }
        }
    }

    public long getRetainedSize() {
        return INSTANCE_SIZE + 8192;
    }

    @Override
    public void close() throws IOException {
        this.pagePositionFileWriter.close();
    }
}

