/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.avro.model;

import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;

public sealed interface AvroLogicalType {
    public static final String DATE = "date";
    public static final String DECIMAL = "decimal";
    public static final String TIME_MILLIS = "time-millis";
    public static final String TIME_MICROS = "time-micros";
    public static final String TIMESTAMP_MILLIS = "timestamp-millis";
    public static final String TIMESTAMP_MICROS = "timestamp-micros";
    public static final String LOCAL_TIMESTAMP_MILLIS = "local-timestamp-millis";
    public static final String LOCAL_TIMESTAMP_MICROS = "local-timestamp-micros";
    public static final String UUID = "uuid";

    public static AvroLogicalType fromAvroLogicalType(LogicalType logicalType, Schema schema) {
        switch (logicalType.getName()) {
            case "date": {
                if (schema.getType() != Schema.Type.INT) break;
                return new DateLogicalType();
            }
            case "decimal": {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                switch (schema.getType()) {
                    case BYTES: {
                        return new BytesDecimalLogicalType(decimal.getPrecision(), decimal.getScale());
                    }
                    case FIXED: {
                        return new FixedDecimalLogicalType(decimal.getPrecision(), decimal.getScale(), schema.getFixedSize());
                    }
                }
                throw new IllegalArgumentException("Unsupported Logical Type %s and schema pairing %s".formatted(logicalType.getName(), schema));
            }
            case "time-millis": {
                if (schema.getType() != Schema.Type.INT) break;
                return new TimeMillisLogicalType();
            }
            case "time-micros": {
                if (schema.getType() != Schema.Type.LONG) break;
                return new TimeMicrosLogicalType();
            }
            case "timestamp-millis": {
                if (schema.getType() != Schema.Type.LONG) break;
                return new TimestampMillisLogicalType();
            }
            case "timestamp-micros": {
                if (schema.getType() != Schema.Type.LONG) break;
                return new TimestampMicrosLogicalType();
            }
            case "uuid": {
                if (schema.getType() != Schema.Type.STRING) break;
                return new StringUUIDLogicalType();
            }
        }
        throw new IllegalArgumentException("Unsupported Logical Type %s and schema pairing %s".formatted(logicalType.getName(), schema));
    }

    public record DateLogicalType() implements AvroLogicalType
    {
    }

    public record BytesDecimalLogicalType(int precision, int scale) implements AvroLogicalType
    {
    }

    public record FixedDecimalLogicalType(int precision, int scale, int fixedSize) implements AvroLogicalType
    {
    }

    public record TimeMillisLogicalType() implements AvroLogicalType
    {
    }

    public record TimeMicrosLogicalType() implements AvroLogicalType
    {
    }

    public record TimestampMillisLogicalType() implements AvroLogicalType
    {
    }

    public record TimestampMicrosLogicalType() implements AvroLogicalType
    {
    }

    public record StringUUIDLogicalType() implements AvroLogicalType
    {
    }
}

