/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.compression;

import io.airlift.compress.v3.hadoop.HadoopInputStream;
import io.airlift.compress.v3.hadoop.HadoopStreams;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public final class ValueDecompressor {
    private final HadoopStreams hadoopStreams;

    ValueDecompressor(HadoopStreams hadoopStreams) {
        this.hadoopStreams = Objects.requireNonNull(hadoopStreams, "hadoopStreams is null");
    }

    public void decompress(Slice compressed, OutputStream uncompressed) throws IOException {
        try (HadoopInputStream decompressorStream = this.hadoopStreams.createInputStream((InputStream)compressed.getInput());){
            decompressorStream.transferTo(uncompressed);
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException("Compressed stream is truncated", e);
        }
    }

    public void decompress(Slice compressed, Slice uncompressed) throws IOException {
        try (HadoopInputStream decompressorStream = this.hadoopStreams.createInputStream((InputStream)compressed.getInput());){
            uncompressed.setBytes(0, (InputStream)decompressorStream, uncompressed.length());
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new IOException("Compressed stream is truncated", e);
        }
    }
}

