/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.encodings.binary;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncoding;
import io.trino.hive.formats.encodings.binary.BlockEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;

public class StructEncoding
extends BlockEncoding {
    private final List<BinaryColumnEncoding> structFields;
    private final RowType rowType;

    public StructEncoding(RowType rowType, List<BinaryColumnEncoding> structFields) {
        super((Type)rowType);
        this.rowType = rowType;
        this.structFields = ImmutableList.copyOf(structFields);
    }

    @Override
    public void encodeValue(Block block, int position, SliceOutput output) {
        SqlRow row = this.rowType.getObject(block, position);
        int rawIndex = row.getRawIndex();
        for (int batchStart = 0; batchStart < row.getFieldCount(); batchStart += 8) {
            int fieldId;
            int batchEnd = Math.min(batchStart + 8, this.structFields.size());
            int nullByte = 0;
            for (fieldId = batchStart; fieldId < batchEnd; ++fieldId) {
                if (row.getRawFieldBlock(fieldId).isNull(rawIndex)) continue;
                nullByte |= 1 << fieldId % 8;
            }
            output.writeByte(nullByte);
            for (fieldId = batchStart; fieldId < batchEnd; ++fieldId) {
                Block fieldBlock = row.getRawFieldBlock(fieldId);
                if (fieldBlock.isNull(rawIndex)) continue;
                BinaryColumnEncoding field = this.structFields.get(fieldId);
                field.encodeValueInto(fieldBlock, rawIndex, output);
            }
        }
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> {
            int fieldId;
            byte nullByte = 0;
            int elementOffset = offset;
            for (fieldId = 0; fieldId < this.structFields.size() && elementOffset < offset + length; ++fieldId) {
                BinaryColumnEncoding field = this.structFields.get(fieldId);
                if (fieldId % 8 == 0) {
                    nullByte = slice.getByte(elementOffset);
                    ++elementOffset;
                }
                if ((nullByte & 1 << fieldId % 8) != 0) {
                    int valueOffset = field.getValueOffset(slice, elementOffset);
                    int valueLength = field.getValueLength(slice, elementOffset);
                    field.decodeValueInto((BlockBuilder)fieldBuilders.get(fieldId), slice, elementOffset + valueOffset, valueLength);
                    elementOffset = elementOffset + valueOffset + valueLength;
                    continue;
                }
                ((BlockBuilder)fieldBuilders.get(fieldId)).appendNull();
            }
            while (fieldId < this.structFields.size()) {
                ((BlockBuilder)fieldBuilders.get(fieldId)).appendNull();
                ++fieldId;
            }
        });
    }
}

